/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import akka.http.scaladsl.Http;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import io.findify.s3mock.S3Mock;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.beam.sdk.io.aws.options.S3Options;
import org.apache.beam.sdk.io.aws.s3.MatchResultMatcher;
import org.apache.beam.sdk.io.aws.s3.S3FileSystem;
import org.apache.beam.sdk.io.aws.s3.S3ResourceId;
import org.apache.beam.sdk.io.aws.s3.S3TestUtils;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class S3FileSystemTest {
    private static S3Mock api;
    private static AmazonS3 client;

    @BeforeClass
    public static void beforeClass() {
        api = new S3Mock.Builder().withInMemoryBackend().build();
        Http.ServerBinding binding = api.start();
        AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration("http://localhost:" + binding.localAddress().getPort(), "us-west-2");
        client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(endpoint)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()))).build();
    }

    @AfterClass
    public static void afterClass() {
        api.stop();
    }

    @Test
    public void testGlobTranslation() {
        Assert.assertEquals((Object)"foo", (Object)S3FileSystem.wildcardToRegexp((String)"foo"));
        Assert.assertEquals((Object)"fo[^/]*o", (Object)S3FileSystem.wildcardToRegexp((String)"fo*o"));
        Assert.assertEquals((Object)"f[^/]*o\\.[^/]", (Object)S3FileSystem.wildcardToRegexp((String)"f*o.?"));
        Assert.assertEquals((Object)"foo-[0-9][^/]*", (Object)S3FileSystem.wildcardToRegexp((String)"foo-[0-9]*"));
        Assert.assertEquals((Object)"foo-[0-9].*", (Object)S3FileSystem.wildcardToRegexp((String)"foo-[0-9]**"));
        Assert.assertEquals((Object)".*foo", (Object)S3FileSystem.wildcardToRegexp((String)"**/*foo"));
        Assert.assertEquals((Object)".*foo", (Object)S3FileSystem.wildcardToRegexp((String)"**foo"));
        Assert.assertEquals((Object)"foo/[^/]*", (Object)S3FileSystem.wildcardToRegexp((String)"foo/*"));
        Assert.assertEquals((Object)"foo[^/]*", (Object)S3FileSystem.wildcardToRegexp((String)"foo*"));
        Assert.assertEquals((Object)"foo/[^/]*/[^/]*/[^/]*", (Object)S3FileSystem.wildcardToRegexp((String)"foo/*/*/*"));
        Assert.assertEquals((Object)"foo/[^/]*/.*", (Object)S3FileSystem.wildcardToRegexp((String)"foo/*/**"));
        Assert.assertEquals((Object)"foo.*baz", (Object)S3FileSystem.wildcardToRegexp((String)"foo**baz"));
    }

    @Test
    public void testGetScheme() {
        S3FileSystem s3FileSystem = new S3FileSystem(S3TestUtils.s3Options());
        Assert.assertEquals((Object)"s3", (Object)s3FileSystem.getScheme());
    }

    @Test
    public void testGetPathStyleAccessEnabled() throws URISyntaxException {
        S3FileSystem s3FileSystem = new S3FileSystem(S3TestUtils.s3OptionsWithCustomEndpointAndPathStyleAccessEnabled());
        URL s3Url = s3FileSystem.getAmazonS3Client().getUrl("bucket", "file");
        Assert.assertEquals((Object)"https://s3.custom.dns/bucket/file", (Object)s3Url.toURI().toString());
    }

    @Test
    public void testCopy() throws IOException {
        this.testCopy(S3TestUtils.s3Options());
        this.testCopy(S3TestUtils.s3OptionsWithSSECustomerKey());
    }

    private GetObjectMetadataRequest createObjectMetadataRequest(S3ResourceId path, S3Options options) {
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(path.getBucket(), path.getKey());
        getObjectMetadataRequest.setSSECustomerKey(options.getSSECustomerKey());
        return getObjectMetadataRequest;
    }

    private void assertGetObjectMetadata(S3FileSystem s3FileSystem, GetObjectMetadataRequest request, S3Options options, ObjectMetadata objectMetadata) {
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.argThat((Matcher)new GetObjectMetadataRequestMatcher(request)))).thenReturn((Object)objectMetadata);
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)s3FileSystem.getAmazonS3Client().getObjectMetadata(request).getSSECustomerKeyMd5());
    }

    private void testCopy(S3Options options) throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId sourcePath = S3ResourceId.fromUri((String)"s3://bucket/from");
        S3ResourceId destinationPath = S3ResourceId.fromUri((String)"s3://bucket/to");
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(0L);
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            objectMetadata.setSSECustomerKeyMd5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        this.assertGetObjectMetadata(s3FileSystem, this.createObjectMetadataRequest(sourcePath, options), options, objectMetadata);
        s3FileSystem.copy(sourcePath, destinationPath);
        ((AmazonS3)Mockito.verify((Object)s3FileSystem.getAmazonS3Client(), (VerificationMode)Mockito.times((int)1))).copyObject((CopyObjectRequest)Matchers.argThat((Matcher)org.hamcrest.Matchers.notNullValue(CopyObjectRequest.class)));
        objectMetadata.setContentLength(0x140000000L);
        this.assertGetObjectMetadata(s3FileSystem, this.createObjectMetadataRequest(sourcePath, options), options, objectMetadata);
        try {
            s3FileSystem.copy(sourcePath, destinationPath);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ((AmazonS3)Mockito.verify((Object)s3FileSystem.getAmazonS3Client(), (VerificationMode)Mockito.never())).copyObject((CopyObjectRequest)Matchers.argThat((Matcher)org.hamcrest.Matchers.nullValue(CopyObjectRequest.class)));
    }

    @Test
    public void testAtomicCopy() {
        this.testAtomicCopy(S3TestUtils.s3Options());
        this.testAtomicCopy(S3TestUtils.s3OptionsWithSSECustomerKey());
    }

    private void testAtomicCopy(S3Options options) {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(options);
        S3ResourceId sourcePath = S3ResourceId.fromUri((String)"s3://bucket/from");
        S3ResourceId destinationPath = S3ResourceId.fromUri((String)"s3://bucket/to");
        CopyObjectResult copyObjectResult = new CopyObjectResult();
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            copyObjectResult.setSSECustomerKeyMd5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(sourcePath.getBucket(), sourcePath.getKey(), destinationPath.getBucket(), destinationPath.getKey());
        copyObjectRequest.setSourceSSECustomerKey(options.getSSECustomerKey());
        copyObjectRequest.setDestinationSSECustomerKey(options.getSSECustomerKey());
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().copyObject((CopyObjectRequest)Matchers.argThat((Matcher)org.hamcrest.Matchers.notNullValue(CopyObjectRequest.class)))).thenReturn((Object)copyObjectResult);
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)s3FileSystem.getAmazonS3Client().copyObject(copyObjectRequest).getSSECustomerKeyMd5());
        ObjectMetadata sourceS3ObjectMetadata = new ObjectMetadata();
        s3FileSystem.atomicCopy(sourcePath, destinationPath, sourceS3ObjectMetadata);
        ((AmazonS3)Mockito.verify((Object)s3FileSystem.getAmazonS3Client(), (VerificationMode)Mockito.times((int)2))).copyObject((CopyObjectRequest)Matchers.argThat((Matcher)org.hamcrest.Matchers.notNullValue(CopyObjectRequest.class)));
    }

    @Test
    public void testMultipartCopy() {
        this.testMultipartCopy(S3TestUtils.s3Options());
        this.testMultipartCopy(S3TestUtils.s3OptionsWithSSECustomerKey());
    }

    private void testMultipartCopy(S3Options options) {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(options);
        S3ResourceId sourcePath = S3ResourceId.fromUri((String)"s3://bucket/from");
        S3ResourceId destinationPath = S3ResourceId.fromUri((String)"s3://bucket/to");
        InitiateMultipartUploadResult initiateMultipartUploadResult = new InitiateMultipartUploadResult();
        initiateMultipartUploadResult.setUploadId("upload-id");
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            initiateMultipartUploadResult.setSSECustomerKeyMd5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().initiateMultipartUpload((InitiateMultipartUploadRequest)Matchers.argThat((Matcher)org.hamcrest.Matchers.notNullValue(InitiateMultipartUploadRequest.class)))).thenReturn((Object)initiateMultipartUploadResult);
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)s3FileSystem.getAmazonS3Client().initiateMultipartUpload(new InitiateMultipartUploadRequest(destinationPath.getBucket(), destinationPath.getKey())).getSSECustomerKeyMd5());
        ObjectMetadata sourceObjectMetadata = new ObjectMetadata();
        sourceObjectMetadata.setContentLength((long)((double)options.getS3UploadBufferSizeBytes().intValue() * 1.5));
        sourceObjectMetadata.setContentEncoding("read-seek-efficient");
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            sourceObjectMetadata.setSSECustomerKeyMd5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        this.assertGetObjectMetadata(s3FileSystem, this.createObjectMetadataRequest(sourcePath, options), options, sourceObjectMetadata);
        CopyPartResult copyPartResult1 = new CopyPartResult();
        copyPartResult1.setETag("etag-1");
        CopyPartResult copyPartResult2 = new CopyPartResult();
        copyPartResult1.setETag("etag-2");
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            copyPartResult1.setSSECustomerKeyMd5(S3TestUtils.getSSECustomerKeyMd5(options));
            copyPartResult2.setSSECustomerKeyMd5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        CopyPartRequest copyPartRequest = new CopyPartRequest();
        copyPartRequest.setSourceSSECustomerKey(options.getSSECustomerKey());
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().copyPart((CopyPartRequest)Matchers.argThat((Matcher)org.hamcrest.Matchers.notNullValue(CopyPartRequest.class)))).thenReturn((Object)copyPartResult1).thenReturn((Object)copyPartResult2);
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)s3FileSystem.getAmazonS3Client().copyPart(copyPartRequest).getSSECustomerKeyMd5());
        s3FileSystem.multipartCopy(sourcePath, destinationPath, sourceObjectMetadata);
        ((AmazonS3)Mockito.verify((Object)s3FileSystem.getAmazonS3Client(), (VerificationMode)Mockito.times((int)1))).completeMultipartUpload((CompleteMultipartUploadRequest)Matchers.argThat((Matcher)org.hamcrest.Matchers.notNullValue(CompleteMultipartUploadRequest.class)));
    }

    @Test
    public void deleteThousandsOfObjectsInMultipleBuckets() throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        ImmutableList buckets = ImmutableList.of((Object)"bucket1", (Object)"bucket2");
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < 2500; ++i) {
            keys.add(String.format("key-%d", i));
        }
        ArrayList<S3ResourceId> paths = new ArrayList<S3ResourceId>();
        for (String bucket : buckets) {
            for (String key : keys) {
                paths.add(S3ResourceId.fromComponents((String)bucket, (String)key));
            }
        }
        s3FileSystem.delete(paths);
        ((AmazonS3)Mockito.verify((Object)s3FileSystem.getAmazonS3Client(), (VerificationMode)Mockito.times((int)6))).deleteObjects((DeleteObjectsRequest)Matchers.argThat((Matcher)org.hamcrest.Matchers.notNullValue(DeleteObjectsRequest.class)));
    }

    @Test
    public void matchNonGlob() {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/filethatexists");
        long lastModifiedMillis = 1540000000000L;
        ObjectMetadata s3ObjectMetadata = new ObjectMetadata();
        s3ObjectMetadata.setContentLength(100L);
        s3ObjectMetadata.setContentEncoding("read-seek-efficient");
        s3ObjectMetadata.setLastModified(new Date(lastModifiedMillis));
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.argThat((Matcher)new GetObjectMetadataRequestMatcher(new GetObjectMetadataRequest(path.getBucket(), path.getKey()))))).thenReturn((Object)s3ObjectMetadata);
        MatchResult result = s3FileSystem.matchNonGlobPath(path);
        Assert.assertThat((Object)result, (Matcher)MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)MatchResult.Metadata.builder().setSizeBytes(100L).setLastModifiedMillis(lastModifiedMillis).setResourceId((ResourceId)path).setIsReadSeekEfficient(true).build())));
    }

    @Test
    public void matchNonGlobNotReadSeekEfficient() {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/filethatexists");
        long lastModifiedMillis = 1540000000000L;
        ObjectMetadata s3ObjectMetadata = new ObjectMetadata();
        s3ObjectMetadata.setContentLength(100L);
        s3ObjectMetadata.setLastModified(new Date(lastModifiedMillis));
        s3ObjectMetadata.setContentEncoding("gzip");
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.argThat((Matcher)new GetObjectMetadataRequestMatcher(new GetObjectMetadataRequest(path.getBucket(), path.getKey()))))).thenReturn((Object)s3ObjectMetadata);
        MatchResult result = s3FileSystem.matchNonGlobPath(path);
        Assert.assertThat((Object)result, (Matcher)MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)MatchResult.Metadata.builder().setSizeBytes(100L).setLastModifiedMillis(lastModifiedMillis).setResourceId((ResourceId)path).setIsReadSeekEfficient(false).build())));
    }

    @Test
    public void matchNonGlobNullContentEncoding() {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/filethatexists");
        long lastModifiedMillis = 1540000000000L;
        ObjectMetadata s3ObjectMetadata = new ObjectMetadata();
        s3ObjectMetadata.setContentLength(100L);
        s3ObjectMetadata.setLastModified(new Date(lastModifiedMillis));
        s3ObjectMetadata.setContentEncoding(null);
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.argThat((Matcher)new GetObjectMetadataRequestMatcher(new GetObjectMetadataRequest(path.getBucket(), path.getKey()))))).thenReturn((Object)s3ObjectMetadata);
        MatchResult result = s3FileSystem.matchNonGlobPath(path);
        Assert.assertThat((Object)result, (Matcher)MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)MatchResult.Metadata.builder().setSizeBytes(100L).setLastModifiedMillis(lastModifiedMillis).setResourceId((ResourceId)path).setIsReadSeekEfficient(true).build())));
    }

    @Test
    public void matchNonGlobNotFound() {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/nonexistentfile");
        AmazonS3Exception exception = new AmazonS3Exception("mock exception");
        exception.setStatusCode(404);
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.argThat((Matcher)new GetObjectMetadataRequestMatcher(new GetObjectMetadataRequest(path.getBucket(), path.getKey()))))).thenThrow(new Throwable[]{exception});
        MatchResult result = s3FileSystem.matchNonGlobPath(path);
        Assert.assertThat((Object)result, (Matcher)MatchResultMatcher.create(MatchResult.Status.NOT_FOUND, new FileNotFoundException()));
    }

    @Test
    public void matchNonGlobForbidden() {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        AmazonS3Exception exception = new AmazonS3Exception("mock exception");
        exception.setStatusCode(403);
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/keyname");
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.argThat((Matcher)new GetObjectMetadataRequestMatcher(new GetObjectMetadataRequest(path.getBucket(), path.getKey()))))).thenThrow(new Throwable[]{exception});
        Assert.assertThat((Object)s3FileSystem.matchNonGlobPath(path), (Matcher)MatchResultMatcher.create(MatchResult.Status.ERROR, new IOException((Throwable)exception)));
    }

    @Test
    public void matchGlob() throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/foo/bar*baz");
        ListObjectsV2Request firstRequest = new ListObjectsV2Request().withBucketName(path.getBucket()).withPrefix(path.getKeyNonWildcardPrefix()).withContinuationToken(null);
        S3ObjectSummary firstMatch = new S3ObjectSummary();
        firstMatch.setBucketName(path.getBucket());
        firstMatch.setKey("foo/bar0baz");
        firstMatch.setSize(100L);
        firstMatch.setLastModified(new Date(1540000000001L));
        S3ObjectSummary secondMatch = new S3ObjectSummary();
        secondMatch.setBucketName(path.getBucket());
        secondMatch.setKey("foo/bar1qux");
        secondMatch.setSize(200L);
        secondMatch.setLastModified(new Date(1540000000002L));
        ListObjectsV2Result firstResult = new ListObjectsV2Result();
        firstResult.setNextContinuationToken("token");
        firstResult.getObjectSummaries().add(firstMatch);
        firstResult.getObjectSummaries().add(secondMatch);
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().listObjectsV2((ListObjectsV2Request)Matchers.argThat((Matcher)new ListObjectsV2RequestArgumentMatches(firstRequest)))).thenReturn((Object)firstResult);
        ListObjectsV2Request secondRequest = new ListObjectsV2Request().withBucketName(path.getBucket()).withPrefix(path.getKeyNonWildcardPrefix()).withContinuationToken("token");
        S3ObjectSummary thirdMatch = new S3ObjectSummary();
        thirdMatch.setBucketName(path.getBucket());
        thirdMatch.setKey("foo/bar2baz");
        thirdMatch.setSize(300L);
        thirdMatch.setLastModified(new Date(1540000000003L));
        ListObjectsV2Result secondResult = new ListObjectsV2Result();
        secondResult.setNextContinuationToken(null);
        secondResult.getObjectSummaries().add(thirdMatch);
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().listObjectsV2((ListObjectsV2Request)Matchers.argThat((Matcher)new ListObjectsV2RequestArgumentMatches(secondRequest)))).thenReturn((Object)secondResult);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentEncoding("");
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.anyObject())).thenReturn((Object)metadata);
        Assert.assertThat((Object)((MatchResult)s3FileSystem.matchGlobPaths((Collection)ImmutableList.of((Object)path)).get(0)), (Matcher)MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)MatchResult.Metadata.builder().setIsReadSeekEfficient(true).setResourceId((ResourceId)S3ResourceId.fromComponents((String)firstMatch.getBucketName(), (String)firstMatch.getKey())).setSizeBytes(firstMatch.getSize()).setLastModifiedMillis(firstMatch.getLastModified().getTime()).build(), (Object)MatchResult.Metadata.builder().setIsReadSeekEfficient(true).setResourceId((ResourceId)S3ResourceId.fromComponents((String)thirdMatch.getBucketName(), (String)thirdMatch.getKey())).setSizeBytes(thirdMatch.getSize()).setLastModifiedMillis(thirdMatch.getLastModified().getTime()).build())));
    }

    @Test
    public void matchGlobWithSlashes() throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/foo/bar\\baz*");
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(path.getBucket()).withPrefix(path.getKeyNonWildcardPrefix()).withContinuationToken(null);
        S3ObjectSummary firstMatch = new S3ObjectSummary();
        firstMatch.setBucketName(path.getBucket());
        firstMatch.setKey("foo/bar\\baz0");
        firstMatch.setSize(100L);
        firstMatch.setLastModified(new Date(1540000000001L));
        S3ObjectSummary secondMatch = new S3ObjectSummary();
        secondMatch.setBucketName(path.getBucket());
        secondMatch.setKey("foo/bar/baz1");
        secondMatch.setSize(200L);
        secondMatch.setLastModified(new Date(1540000000002L));
        ListObjectsV2Result result = new ListObjectsV2Result();
        result.getObjectSummaries().add(firstMatch);
        result.getObjectSummaries().add(secondMatch);
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().listObjectsV2((ListObjectsV2Request)Matchers.argThat((Matcher)new ListObjectsV2RequestArgumentMatches(request)))).thenReturn((Object)result);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentEncoding("");
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.anyObject())).thenReturn((Object)metadata);
        Assert.assertThat((Object)((MatchResult)s3FileSystem.matchGlobPaths((Collection)ImmutableList.of((Object)path)).get(0)), (Matcher)MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)MatchResult.Metadata.builder().setIsReadSeekEfficient(true).setResourceId((ResourceId)S3ResourceId.fromComponents((String)firstMatch.getBucketName(), (String)firstMatch.getKey())).setSizeBytes(firstMatch.getSize()).setLastModifiedMillis(firstMatch.getLastModified().getTime()).build())));
    }

    @Test
    public void matchVariousInvokeThreadPool() throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        AmazonS3Exception notFoundException = new AmazonS3Exception("mock exception");
        notFoundException.setStatusCode(404);
        S3ResourceId pathNotExist = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/nonexistentfile");
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.argThat((Matcher)new GetObjectMetadataRequestMatcher(new GetObjectMetadataRequest(pathNotExist.getBucket(), pathNotExist.getKey()))))).thenThrow(new Throwable[]{notFoundException});
        AmazonS3Exception forbiddenException = new AmazonS3Exception("mock exception");
        forbiddenException.setStatusCode(403);
        S3ResourceId pathForbidden = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/forbiddenfile");
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.argThat((Matcher)new GetObjectMetadataRequestMatcher(new GetObjectMetadataRequest(pathForbidden.getBucket(), pathForbidden.getKey()))))).thenThrow(new Throwable[]{forbiddenException});
        S3ResourceId pathExist = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/filethatexists");
        ObjectMetadata s3ObjectMetadata = new ObjectMetadata();
        s3ObjectMetadata.setContentLength(100L);
        s3ObjectMetadata.setLastModified(new Date(1540000000000L));
        s3ObjectMetadata.setContentEncoding("not-gzip");
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.argThat((Matcher)new GetObjectMetadataRequestMatcher(new GetObjectMetadataRequest(pathExist.getBucket(), pathExist.getKey()))))).thenReturn((Object)s3ObjectMetadata);
        S3ResourceId pathGlob = S3ResourceId.fromUri((String)"s3://testbucket/path/part*");
        S3ObjectSummary foundListObject = new S3ObjectSummary();
        foundListObject.setBucketName(pathGlob.getBucket());
        foundListObject.setKey("path/part-0");
        foundListObject.setSize(200L);
        foundListObject.setLastModified(new Date(1541000000000L));
        ListObjectsV2Result listObjectsResult = new ListObjectsV2Result();
        listObjectsResult.setNextContinuationToken(null);
        listObjectsResult.getObjectSummaries().add(foundListObject);
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().listObjectsV2((ListObjectsV2Request)Matchers.notNull(ListObjectsV2Request.class))).thenReturn((Object)listObjectsResult);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentEncoding("");
        Mockito.when((Object)s3FileSystem.getAmazonS3Client().getObjectMetadata((GetObjectMetadataRequest)Matchers.argThat((Matcher)new GetObjectMetadataRequestMatcher(new GetObjectMetadataRequest(pathGlob.getBucket(), "path/part-0"))))).thenReturn((Object)metadata);
        Assert.assertThat((Object)s3FileSystem.match((List)ImmutableList.of((Object)pathNotExist.toString(), (Object)pathForbidden.toString(), (Object)pathExist.toString(), (Object)pathGlob.toString())), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{MatchResultMatcher.create(MatchResult.Status.NOT_FOUND, new FileNotFoundException()), MatchResultMatcher.create(MatchResult.Status.ERROR, new IOException((Throwable)forbiddenException)), MatchResultMatcher.create(100L, 1540000000000L, (ResourceId)pathExist, true), MatchResultMatcher.create(200L, 1541000000000L, (ResourceId)S3ResourceId.fromComponents((String)pathGlob.getBucket(), (String)foundListObject.getKey()), true)}));
    }

    @Test
    public void testWriteAndRead() throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options(), client);
        client.createBucket("testbucket");
        byte[] writtenArray = new byte[]{0};
        ByteBuffer bb = ByteBuffer.allocate(writtenArray.length);
        bb.put(writtenArray);
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/foo/bar.txt");
        WritableByteChannel writableByteChannel = s3FileSystem.create(path, (CreateOptions)((CreateOptions.StandardCreateOptions.Builder)CreateOptions.StandardCreateOptions.builder().setMimeType("application/text")).build());
        writableByteChannel.write(bb);
        writableByteChannel.close();
        ByteBuffer bb2 = ByteBuffer.allocate(writtenArray.length);
        ReadableByteChannel open = s3FileSystem.open(path);
        open.read(bb2);
        byte[] readArray = bb2.array();
        Assert.assertArrayEquals((byte[])readArray, (byte[])writtenArray);
        open.close();
    }

    private static class GetObjectMetadataRequestMatcher
    extends ArgumentMatcher<GetObjectMetadataRequest> {
        private final GetObjectMetadataRequest expected;

        GetObjectMetadataRequestMatcher(GetObjectMetadataRequest expected) {
            this.expected = expected;
        }

        public boolean matches(Object obj) {
            if (!(obj instanceof GetObjectMetadataRequest)) {
                return false;
            }
            GetObjectMetadataRequest actual = (GetObjectMetadataRequest)obj;
            return actual.getBucketName().equals(this.expected.getBucketName()) && actual.getKey().equals(this.expected.getKey());
        }
    }

    static class ListObjectsV2RequestArgumentMatches
    extends ArgumentMatcher<ListObjectsV2Request> {
        private final ListObjectsV2Request expected;

        ListObjectsV2RequestArgumentMatches(ListObjectsV2Request expected) {
            this.expected = (ListObjectsV2Request)Preconditions.checkNotNull((Object)expected);
        }

        public boolean matches(Object argument) {
            if (argument instanceof ListObjectsV2Request) {
                ListObjectsV2Request actual = (ListObjectsV2Request)argument;
                return this.expected.getBucketName().equals(actual.getBucketName()) && this.expected.getPrefix().equals(actual.getPrefix()) && (this.expected.getContinuationToken() == null ? actual.getContinuationToken() == null : this.expected.getContinuationToken().equals(actual.getContinuationToken()));
            }
            return false;
        }
    }
}

