/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

class MatchResultMatcher
extends BaseMatcher<MatchResult> {
    private final MatchResult.Status expectedStatus;
    private final List<MatchResult.Metadata> expectedMetadata;
    private final IOException expectedException;

    private MatchResultMatcher(MatchResult.Status expectedStatus, List<MatchResult.Metadata> expectedMetadata, IOException expectedException) {
        this.expectedStatus = (MatchResult.Status)Preconditions.checkNotNull((Object)expectedStatus);
        Preconditions.checkArgument((boolean)(expectedMetadata == null ^ expectedException == null));
        this.expectedMetadata = expectedMetadata;
        this.expectedException = expectedException;
    }

    static MatchResultMatcher create(List<MatchResult.Metadata> expectedMetadata) {
        return new MatchResultMatcher(MatchResult.Status.OK, expectedMetadata, null);
    }

    private static MatchResultMatcher create(MatchResult.Metadata expectedMetadata) {
        return MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)expectedMetadata));
    }

    static MatchResultMatcher create(long sizeBytes, long lastModifiedMillis, ResourceId resourceId, boolean isReadSeekEfficient) {
        return MatchResultMatcher.create(MatchResult.Metadata.builder().setSizeBytes(sizeBytes).setLastModifiedMillis(lastModifiedMillis).setResourceId(resourceId).setIsReadSeekEfficient(isReadSeekEfficient).build());
    }

    static MatchResultMatcher create(MatchResult.Status expectedStatus, IOException expectedException) {
        return new MatchResultMatcher(expectedStatus, null, expectedException);
    }

    static MatchResultMatcher create(MatchResult expected) {
        MatchResult.Status expectedStatus = expected.status();
        List expectedMetadata = null;
        IOException expectedException = null;
        try {
            expectedMetadata = expected.metadata();
        }
        catch (IOException e) {
            expectedException = e;
        }
        return new MatchResultMatcher(expectedStatus, expectedMetadata, expectedException);
    }

    public boolean matches(Object actual) {
        List actualMetadata;
        if (actual == null) {
            return false;
        }
        if (!(actual instanceof MatchResult)) {
            return false;
        }
        MatchResult actualResult = (MatchResult)actual;
        if (!this.expectedStatus.equals((Object)actualResult.status())) {
            return false;
        }
        try {
            actualMetadata = actualResult.metadata();
        }
        catch (IOException e) {
            return this.expectedException != null && this.expectedException.toString().equals(e.toString());
        }
        return this.expectedMetadata != null && this.expectedMetadata.equals(actualMetadata);
    }

    public void describeTo(Description description) {
        if (this.expectedMetadata != null) {
            description.appendText(MatchResult.create((MatchResult.Status)this.expectedStatus, this.expectedMetadata).toString());
        } else {
            description.appendText(MatchResult.create((MatchResult.Status)this.expectedStatus, (IOException)this.expectedException).toString());
        }
    }
}

