/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.options;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.beam.sdk.io.aws.options.AwsModule;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AwsModuleTest {
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new AwsModule());

    @Test
    public void testObjectMapperIsAbleToFindModule() {
        List modules = ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader());
        Assert.assertThat((Object)modules, (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(AwsModule.class)));
    }

    @Test
    public void testAWSStaticCredentialsProviderSerializationDeserialization() throws Exception {
        String awsKeyId = "key-id";
        String awsSecretKey = "secret-key";
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(awsKeyId, awsSecretKey));
        String serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        AWSCredentialsProvider deserializedCredentialsProvider = (AWSCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AWSCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        Assert.assertEquals((Object)credentialsProvider.getCredentials().getAWSAccessKeyId(), (Object)deserializedCredentialsProvider.getCredentials().getAWSAccessKeyId());
        Assert.assertEquals((Object)credentialsProvider.getCredentials().getAWSSecretKey(), (Object)deserializedCredentialsProvider.getCredentials().getAWSSecretKey());
    }

    @Test
    public void testPropertiesFileCredentialsProviderSerializationDeserialization() throws Exception {
        String credentialsFilePath = "/path/to/file";
        PropertiesFileCredentialsProvider credentialsProvider = new PropertiesFileCredentialsProvider(credentialsFilePath);
        String serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        AWSCredentialsProvider deserializedCredentialsProvider = (AWSCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AWSCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        Field field = PropertiesFileCredentialsProvider.class.getDeclaredField("credentialsFilePath");
        field.setAccessible(true);
        String deserializedCredentialsFilePath = (String)field.get(deserializedCredentialsProvider);
        Assert.assertEquals((Object)credentialsFilePath, (Object)deserializedCredentialsFilePath);
    }

    @Test
    public void testClasspathPropertiesFileCredentialsProviderSerializationDeserialization() throws Exception {
        String credentialsFilePath = "/path/to/file";
        ClasspathPropertiesFileCredentialsProvider credentialsProvider = new ClasspathPropertiesFileCredentialsProvider(credentialsFilePath);
        String serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        AWSCredentialsProvider deserializedCredentialsProvider = (AWSCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AWSCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        Field field = ClasspathPropertiesFileCredentialsProvider.class.getDeclaredField("credentialsFilePath");
        field.setAccessible(true);
        String deserializedCredentialsFilePath = (String)field.get(deserializedCredentialsProvider);
        Assert.assertEquals((Object)credentialsFilePath, (Object)deserializedCredentialsFilePath);
    }

    @Test
    public void testSingletonAWSCredentialsProviderSerializationDeserialization() throws Exception {
        DefaultAWSCredentialsProviderChain credentialsProvider = new DefaultAWSCredentialsProviderChain();
        String serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        AWSCredentialsProvider deserializedCredentialsProvider = (AWSCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AWSCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        credentialsProvider = new EnvironmentVariableCredentialsProvider();
        serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        deserializedCredentialsProvider = (AWSCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AWSCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        credentialsProvider = new SystemPropertiesCredentialsProvider();
        serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        deserializedCredentialsProvider = (AWSCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AWSCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        credentialsProvider = new ProfileCredentialsProvider();
        serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        deserializedCredentialsProvider = (AWSCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AWSCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        credentialsProvider = new EC2ContainerCredentialsProviderWrapper();
        serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        deserializedCredentialsProvider = (AWSCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AWSCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
    }

    @Test
    public void testSSECustomerKeySerializationDeserialization() throws Exception {
        String key = "86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=";
        Object md5 = null;
        String algorithm = "AES256";
        SSECustomerKey value = new SSECustomerKey("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=");
        String valueAsJson = this.objectMapper.writeValueAsString((Object)value);
        SSECustomerKey valueDes = (SSECustomerKey)this.objectMapper.readValue(valueAsJson, SSECustomerKey.class);
        Assert.assertEquals((Object)"86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=", (Object)valueDes.getKey());
        Assert.assertEquals((Object)"AES256", (Object)valueDes.getAlgorithm());
        Assert.assertEquals(md5, (Object)valueDes.getMd5());
    }

    @Test
    public void testSSEAwsKeyManagementParamsSerializationDeserialization() throws Exception {
        String awsKmsKeyId = "arn:aws:kms:eu-west-1:123456789012:key/dc123456-7890-ABCD-EF01-234567890ABC";
        String encryption = "aws:kms";
        SSEAwsKeyManagementParams value = new SSEAwsKeyManagementParams("arn:aws:kms:eu-west-1:123456789012:key/dc123456-7890-ABCD-EF01-234567890ABC");
        String valueAsJson = this.objectMapper.writeValueAsString((Object)value);
        SSEAwsKeyManagementParams valueDes = (SSEAwsKeyManagementParams)this.objectMapper.readValue(valueAsJson, SSEAwsKeyManagementParams.class);
        Assert.assertEquals((Object)"arn:aws:kms:eu-west-1:123456789012:key/dc123456-7890-ABCD-EF01-234567890ABC", (Object)valueDes.getAwsKmsKeyId());
        Assert.assertEquals((Object)"aws:kms", (Object)valueDes.getEncryption());
    }

    @Test
    public void testClientConfigurationSerializationDeserialization() throws Exception {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setProxyHost("localhost");
        clientConfiguration.setProxyPort(1234);
        clientConfiguration.setProxyUsername("username");
        clientConfiguration.setProxyPassword("password");
        String valueAsJson = this.objectMapper.writeValueAsString((Object)clientConfiguration);
        ClientConfiguration valueDes = (ClientConfiguration)this.objectMapper.readValue(valueAsJson, ClientConfiguration.class);
        Assert.assertEquals((Object)"localhost", (Object)valueDes.getProxyHost());
        Assert.assertEquals((long)1234L, (long)valueDes.getProxyPort());
        Assert.assertEquals((Object)"username", (Object)valueDes.getProxyUsername());
        Assert.assertEquals((Object)"password", (Object)valueDes.getProxyPassword());
    }
}

