/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Rule;
import org.testcontainers.containers.localstack.LocalStackContainer;

class DynamoDBIOTestHelper
implements Serializable {
    @Rule
    private static LocalStackContainer localStackContainer = new LocalStackContainer().withServices(new LocalStackContainer.Service[]{LocalStackContainer.Service.DYNAMODB});
    private static AmazonDynamoDB dynamoDBClient;
    static final String ATTR_NAME_1 = "hashKey1";
    static final String ATTR_NAME_2 = "rangeKey2";

    DynamoDBIOTestHelper() {
    }

    static void startServerClient() {
        localStackContainer.start();
        if (dynamoDBClient == null) {
            dynamoDBClient = (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(localStackContainer.getEndpointConfiguration(LocalStackContainer.Service.DYNAMODB))).withCredentials(localStackContainer.getDefaultCredentialsProvider())).build();
        }
    }

    static void stopServerClient(String tableName) {
        if (dynamoDBClient != null) {
            dynamoDBClient.deleteTable(tableName);
            dynamoDBClient.shutdown();
        }
        localStackContainer.stop();
    }

    static AmazonDynamoDB getDynamoDBClient() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(localStackContainer.getEndpointConfiguration(LocalStackContainer.Service.DYNAMODB))).withCredentials(localStackContainer.getDefaultCredentialsProvider())).build();
    }

    static List<Map<String, AttributeValue>> generateTestData(String tableName, int numOfItems) {
        BatchWriteItemRequest batchWriteItemRequest = DynamoDBIOTestHelper.generateBatchWriteItemRequest(tableName, numOfItems);
        dynamoDBClient.batchWriteItem(batchWriteItemRequest);
        ScanResult scanResult = dynamoDBClient.scan(new ScanRequest().withTableName(tableName));
        List items = scanResult.getItems();
        Assert.assertEquals((long)numOfItems, (long)items.size());
        return items;
    }

    static BatchWriteItemRequest generateBatchWriteItemRequest(String tableName, int numOfItems) {
        BatchWriteItemRequest batchWriteItemRequest = new BatchWriteItemRequest();
        batchWriteItemRequest.addRequestItemsEntry(tableName, DynamoDBIOTestHelper.generateWriteRequests(numOfItems));
        return batchWriteItemRequest;
    }

    static List<WriteRequest> generateWriteRequests(int numOfItem) {
        ArrayList<WriteRequest> writeRequests = new ArrayList<WriteRequest>();
        for (int i = 1; i <= numOfItem; ++i) {
            WriteRequest writeRequest = new WriteRequest();
            writeRequest.setPutRequest(DynamoDBIOTestHelper.generatePutRequest("hashKeyDataStr_" + i, "1000" + i));
            writeRequests.add(writeRequest);
        }
        return writeRequests;
    }

    private static PutRequest generatePutRequest(String hashKeyData, String rangeKeyData) {
        PutRequest putRequest = new PutRequest();
        putRequest.addItemEntry(ATTR_NAME_1, new AttributeValue(hashKeyData));
        putRequest.addItemEntry(ATTR_NAME_2, new AttributeValue().withN(rangeKeyData));
        return putRequest;
    }

    static void createTestTable(String tableName) {
        CreateTableResult res = DynamoDBIOTestHelper.createDynamoTable(tableName);
        TableDescription tableDesc = res.getTableDescription();
        Assert.assertEquals((Object)tableName, (Object)tableDesc.getTableName());
        Assert.assertTrue((boolean)tableDesc.getKeySchema().toString().contains(ATTR_NAME_1));
        Assert.assertTrue((boolean)tableDesc.getKeySchema().toString().contains(ATTR_NAME_2));
        Assert.assertEquals((Object)tableDesc.getProvisionedThroughput().getReadCapacityUnits(), (Object)1000L);
        Assert.assertEquals((Object)tableDesc.getProvisionedThroughput().getWriteCapacityUnits(), (Object)1000L);
        Assert.assertEquals((Object)"ACTIVE", (Object)tableDesc.getTableStatus());
        Assert.assertEquals((Object)("arn:aws:dynamodb:us-east-1:000000000000:table/" + tableName), (Object)tableDesc.getTableArn());
        ListTablesResult tables = dynamoDBClient.listTables();
        Assert.assertEquals((long)1L, (long)tables.getTableNames().size());
    }

    private static CreateTableResult createDynamoTable(String tableName) {
        ImmutableList attributeDefinitions = ImmutableList.of((Object)new AttributeDefinition(ATTR_NAME_1, ScalarAttributeType.S), (Object)new AttributeDefinition(ATTR_NAME_2, ScalarAttributeType.N));
        ImmutableList ks = ImmutableList.of((Object)new KeySchemaElement(ATTR_NAME_1, KeyType.HASH), (Object)new KeySchemaElement(ATTR_NAME_2, KeyType.RANGE));
        ProvisionedThroughput provisionedthroughput = new ProvisionedThroughput(Long.valueOf(1000L), Long.valueOf(1000L));
        CreateTableRequest request = new CreateTableRequest().withTableName(tableName).withAttributeDefinitions((Collection)attributeDefinitions).withKeySchema((Collection)ks).withProvisionedThroughput(provisionedthroughput);
        return dynamoDBClient.createTable(request);
    }
}

