/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.beam.sdk.io.aws.dynamodb.AttributeValueCoder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;

public class AttributeValueCoderTest {
    @Test
    public void shouldPassForStringType() throws IOException {
        AttributeValue expected = new AttributeValue();
        expected.setS("testing");
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForNumberType() throws IOException {
        AttributeValue expected = new AttributeValue();
        expected.setN("123");
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForBooleanType() throws IOException {
        AttributeValue expected = new AttributeValue();
        expected.setBOOL(Boolean.valueOf(false));
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForByteArray() throws IOException {
        AttributeValue expected = new AttributeValue();
        expected.setB(ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)));
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForListOfString() throws IOException {
        AttributeValue expected = new AttributeValue();
        expected.setSS((Collection)ImmutableList.of((Object)"foo", (Object)"bar"));
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForOneListOfNumber() throws IOException {
        AttributeValue expected = new AttributeValue();
        expected.setNS((Collection)ImmutableList.of((Object)"123", (Object)"456"));
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForOneListOfByteArray() throws IOException {
        AttributeValue expected = new AttributeValue();
        expected.setBS((Collection)ImmutableList.of((Object)ByteBuffer.wrap("mylistbyte1".getBytes(StandardCharsets.UTF_8)), (Object)ByteBuffer.wrap("mylistbyte2".getBytes(StandardCharsets.UTF_8))));
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForListType() throws IOException {
        AttributeValue expected = new AttributeValue();
        ArrayList<AttributeValue> listAttr = new ArrayList<AttributeValue>();
        listAttr.add(new AttributeValue("innerMapValue1"));
        listAttr.add(new AttributeValue().withN("8976234"));
        expected.setL(listAttr);
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForMapType() throws IOException {
        AttributeValue expected = new AttributeValue();
        HashMap<String, AttributeValue> attrMap = new HashMap<String, AttributeValue>();
        attrMap.put("innerMapAttr1", new AttributeValue("innerMapValue1"));
        attrMap.put("innerMapAttr2", new AttributeValue().withB(ByteBuffer.wrap("8976234".getBytes(StandardCharsets.UTF_8))));
        expected.setM(attrMap);
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForNullType() throws IOException {
        AttributeValue expected = new AttributeValue();
        expected.setNULL(Boolean.valueOf(true));
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

