/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageSystemAttributeName;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws.sqs.SqsCheckpointMark;
import org.apache.beam.sdk.io.aws.sqs.SqsUnboundedSource;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class SqsUnboundedReader
extends UnboundedSource.UnboundedReader<Message>
implements Serializable {
    public static final int MAX_NUMBER_OF_MESSAGES = 10;
    private final SqsUnboundedSource source;
    private Message current;
    private final Queue<Message> messagesNotYetRead;
    private List<Message> messagesToDelete;
    private Instant oldestPendingTimestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;

    public SqsUnboundedReader(SqsUnboundedSource source, SqsCheckpointMark sqsCheckpointMark) {
        this.source = source;
        this.current = null;
        this.messagesNotYetRead = new ArrayDeque<Message>();
        this.messagesToDelete = new ArrayList<Message>();
        if (sqsCheckpointMark != null) {
            this.messagesToDelete.addAll(sqsCheckpointMark.getMessagesToDelete());
        }
    }

    public Instant getWatermark() {
        return this.oldestPendingTimestamp;
    }

    public Message getCurrent() throws NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    public Instant getCurrentTimestamp() throws NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.getTimestamp(this.current);
    }

    public byte[] getCurrentRecordId() throws NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current.getMessageId().getBytes(StandardCharsets.UTF_8);
    }

    public UnboundedSource.CheckpointMark getCheckpointMark() {
        return new SqsCheckpointMark(this, this.messagesToDelete);
    }

    public SqsUnboundedSource getCurrentSource() {
        return this.source;
    }

    public boolean start() {
        return this.advance();
    }

    public boolean advance() {
        if (this.messagesNotYetRead.isEmpty()) {
            this.pull();
        }
        this.current = this.messagesNotYetRead.poll();
        if (this.current == null) {
            return false;
        }
        this.messagesToDelete.add(this.current);
        Instant currentMessageTimestamp = this.getCurrentTimestamp();
        if (this.getCurrentTimestamp().isBefore((ReadableInstant)this.oldestPendingTimestamp)) {
            this.oldestPendingTimestamp = currentMessageTimestamp;
        }
        return true;
    }

    public void close() {
    }

    void delete(Collection<Message> messages) {
        for (Message message : messages) {
            if (!this.messagesToDelete.contains(message)) continue;
            this.source.getSqs().deleteMessage(this.source.getRead().queueUrl(), message.getReceiptHandle());
            Instant currentMessageTimestamp = this.getTimestamp(message);
            if (!currentMessageTimestamp.isAfter((ReadableInstant)this.oldestPendingTimestamp)) continue;
            this.oldestPendingTimestamp = currentMessageTimestamp;
        }
    }

    private void pull() {
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(this.source.getRead().queueUrl());
        receiveMessageRequest.setMaxNumberOfMessages(Integer.valueOf(10));
        receiveMessageRequest.setAttributeNames(Arrays.asList(MessageSystemAttributeName.SentTimestamp.toString()));
        ReceiveMessageResult receiveMessageResult = this.source.getSqs().receiveMessage(receiveMessageRequest);
        List messages = receiveMessageResult.getMessages();
        if (messages == null || messages.isEmpty()) {
            return;
        }
        for (Message message : messages) {
            this.messagesNotYetRead.add(message);
        }
    }

    private Instant getTimestamp(Message message) {
        return new Instant(Long.parseLong((String)message.getAttributes().get(MessageSystemAttributeName.SentTimestamp.toString())));
    }
}

