/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.google.auto.value.AutoValue;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws.options.AwsOptions;
import org.apache.beam.sdk.io.aws.sqs.AutoValue_SqsIO_Read;
import org.apache.beam.sdk.io.aws.sqs.AutoValue_SqsIO_Write;
import org.apache.beam.sdk.io.aws.sqs.SqsConfiguration;
import org.apache.beam.sdk.io.aws.sqs.SqsUnboundedSource;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.joda.time.Duration;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SqsIO {
    public static Read read() {
        return new AutoValue_SqsIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).build();
    }

    public static Write write() {
        return new AutoValue_SqsIO_Write.Builder().build();
    }

    private SqsIO() {
    }

    private static class SqsWriteFn
    extends DoFn<SendMessageRequest, Void> {
        private final SqsConfiguration sqsConfiguration;
        private transient AmazonSQS sqs;

        SqsWriteFn(SqsConfiguration sqsConfiguration) {
            this.sqsConfiguration = sqsConfiguration;
        }

        @DoFn.Setup
        public void setup() {
            this.sqs = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withClientConfiguration(this.sqsConfiguration.getClientConfiguration())).withCredentials(this.sqsConfiguration.getAwsCredentialsProvider())).withRegion(this.sqsConfiguration.getAwsRegion())).build();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext processContext) throws Exception {
            this.sqs.sendMessage((SendMessageRequest)processContext.element());
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            if (this.sqs != null) {
                this.sqs.shutdown();
            }
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<SendMessageRequest>, PDone> {
        abstract Builder toBuilder();

        public PDone expand(PCollection<SendMessageRequest> input) {
            input.apply((PTransform)ParDo.of((DoFn)new SqsWriteFn(new SqsConfiguration((AwsOptions)input.getPipeline().getOptions().as(AwsOptions.class)))));
            return PDone.in((Pipeline)input.getPipeline());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Write build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Message>> {
        @Nullable
        abstract String queueUrl();

        abstract long maxNumRecords();

        @Nullable
        abstract Duration maxReadTime();

        abstract Builder toBuilder();

        public Read withMaxNumRecords(long maxNumRecords) {
            return this.toBuilder().setMaxNumRecords(maxNumRecords).build();
        }

        public Read withMaxReadTime(Duration maxReadTime) {
            return this.toBuilder().setMaxReadTime(maxReadTime).build();
        }

        public Read withQueueUrl(String queueUrl) {
            Preconditions.checkArgument((queueUrl != null ? 1 : 0) != 0, (Object)"queueUrl can not be null");
            Preconditions.checkArgument((!queueUrl.isEmpty() ? 1 : 0) != 0, (Object)"queueUrl can not be empty");
            return this.toBuilder().setQueueUrl(queueUrl).build();
        }

        public PCollection<Message> expand(PBegin input) {
            Read.Unbounded unbounded;
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new SqsUnboundedSource(this, new SqsConfiguration((AwsOptions)input.getPipeline().getOptions().as(AwsOptions.class))));
            if (this.maxNumRecords() < Long.MAX_VALUE || this.maxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.maxReadTime()).withMaxNumRecords(this.maxNumRecords());
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setQueueUrl(String var1);

            abstract Builder setMaxNumRecords(long var1);

            abstract Builder setMaxReadTime(Duration var1);

            abstract Read build();
        }
    }
}

