/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import org.apache.beam.sdk.io.aws.options.S3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws.options.S3Options;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultS3ClientBuilderFactory
implements S3ClientBuilderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultS3ClientBuilderFactory.class);

    @Override
    public AmazonS3ClientBuilder createBuilder(S3Options s3Options) {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(s3Options.getAwsCredentialsProvider());
        if (s3Options.getClientConfiguration() != null) {
            builder = (AmazonS3ClientBuilder)builder.withClientConfiguration(s3Options.getClientConfiguration());
        }
        if (!Strings.isNullOrEmpty((String)s3Options.getAwsServiceEndpoint())) {
            builder = (AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(s3Options.getAwsServiceEndpoint(), s3Options.getAwsRegion()));
        } else if (!Strings.isNullOrEmpty((String)s3Options.getAwsRegion())) {
            builder = (AmazonS3ClientBuilder)builder.withRegion(s3Options.getAwsRegion());
        } else {
            LOG.info("The AWS S3 Beam extension was included in this build, but the awsRegion flag was not specified. If you don't plan to use S3, then ignore this message.");
        }
        return builder;
    }
}

