/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws.s3.S3FileSystem;
import org.apache.beam.sdk.io.aws.s3.S3ResourceId;

final class AutoValue_S3FileSystem_PathWithEncoding
extends S3FileSystem.PathWithEncoding {
    private final S3ResourceId path;
    private final String contentEncoding;
    private final IOException exception;

    AutoValue_S3FileSystem_PathWithEncoding(S3ResourceId path, @Nullable String contentEncoding, @Nullable IOException exception) {
        if (path == null) {
            throw new NullPointerException("Null path");
        }
        this.path = path;
        this.contentEncoding = contentEncoding;
        this.exception = exception;
    }

    @Override
    S3ResourceId getPath() {
        return this.path;
    }

    @Override
    @Nullable
    String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    @Nullable
    IOException getException() {
        return this.exception;
    }

    public String toString() {
        return "PathWithEncoding{path=" + this.path + ", contentEncoding=" + this.contentEncoding + ", exception=" + this.exception + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof S3FileSystem.PathWithEncoding) {
            S3FileSystem.PathWithEncoding that = (S3FileSystem.PathWithEncoding)o;
            return this.path.equals(that.getPath()) && (this.contentEncoding == null ? that.getContentEncoding() == null : this.contentEncoding.equals(that.getContentEncoding())) && (this.exception == null ? that.getException() == null : this.exception.equals(that.getException()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.path.hashCode();
        h$ *= 1000003;
        h$ ^= this.contentEncoding == null ? 0 : this.contentEncoding.hashCode();
        h$ *= 1000003;
        return h$ ^= this.exception == null ? 0 : this.exception.hashCode();
    }
}

