/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.sdk.fn.stream.PrefetchableIterators;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PrefetchableIteratorsTest {
    @Test
    public void testEmpty() {
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.emptyIterator(), new Object[0]);
        PrefetchableIteratorsTest.verifyIsAlwaysReady(PrefetchableIterators.emptyIterator());
    }

    @Test
    public void testFromArray() {
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.fromArray((Object[])new String[]{"A", "B", "C"}), new String[]{"A", "B", "C"});
        PrefetchableIteratorsTest.verifyIsAlwaysReady(PrefetchableIterators.fromArray((Object[])new String[]{"A", "B", "C"}));
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.fromArray((Object[])new Object[0]), new Object[0]);
        PrefetchableIteratorsTest.verifyIsAlwaysReady(PrefetchableIterators.fromArray((Object[])new Object[0]));
    }

    @Test
    public void testConcat() {
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.concat((Iterator[])new Iterator[0]), new Object[0]);
        PrefetchableIterator instance = PrefetchableIterators.fromArray((Object[])new String[]{"A", "B"});
        Assert.assertSame((Object)PrefetchableIterators.concat((Iterator[])new Iterator[]{instance}), (Object)instance);
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.concat((Iterator[])new Iterator[]{PrefetchableIterators.fromArray((Object[])new Object[0]), PrefetchableIterators.fromArray((Object[])new Object[0]), PrefetchableIterators.fromArray((Object[])new Object[0])}), new Object[0]);
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.concat((Iterator[])new Iterator[]{PrefetchableIterators.fromArray((Object[])new String[]{"A", "B"}), PrefetchableIterators.fromArray((Object[])new String[0]), PrefetchableIterators.fromArray((Object[])new String[0])}), new String[]{"A", "B"});
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.concat((Iterator[])new Iterator[]{PrefetchableIterators.fromArray((Object[])new String[0]), PrefetchableIterators.fromArray((Object[])new String[]{"C", "D"}), PrefetchableIterators.fromArray((Object[])new String[0])}), new String[]{"C", "D"});
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.concat((Iterator[])new Iterator[]{PrefetchableIterators.fromArray((Object[])new String[0]), PrefetchableIterators.fromArray((Object[])new String[0]), PrefetchableIterators.fromArray((Object[])new String[]{"E", "F"})}), new String[]{"E", "F"});
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.concat((Iterator[])new Iterator[]{PrefetchableIterators.fromArray((Object[])new String[0]), PrefetchableIterators.fromArray((Object[])new String[]{"C", "D"}), PrefetchableIterators.fromArray((Object[])new String[]{"E", "F"})}), new String[]{"C", "D", "E", "F"});
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.concat((Iterator[])new Iterator[]{PrefetchableIterators.fromArray((Object[])new String[]{"A", "B"}), PrefetchableIterators.fromArray((Object[])new String[0]), PrefetchableIterators.fromArray((Object[])new String[]{"E", "F"})}), new String[]{"A", "B", "E", "F"});
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.concat((Iterator[])new Iterator[]{PrefetchableIterators.fromArray((Object[])new String[]{"A", "B"}), PrefetchableIterators.fromArray((Object[])new String[]{"C", "D"}), PrefetchableIterators.fromArray((Object[])new String[0])}), new String[]{"A", "B", "C", "D"});
        PrefetchableIteratorsTest.verifyIterator(PrefetchableIterators.concat((Iterator[])new Iterator[]{PrefetchableIterators.fromArray((Object[])new String[]{"A", "B"}), PrefetchableIterators.fromArray((Object[])new String[]{"C", "D"}), PrefetchableIterators.fromArray((Object[])new String[]{"E", "F"})}), new String[]{"A", "B", "C", "D", "E", "F"});
    }

    @Test
    public void testConcatIsReadyAdvancesToNextIteratorWhenAble() {
        NeverReady readyAfterPrefetch1 = new NeverReady(PrefetchableIterators.fromArray((Object[])new String[]{"A", "B"}));
        ReadyAfterPrefetch readyAfterPrefetch2 = new ReadyAfterPrefetch(PrefetchableIterators.fromArray((Object[])new String[]{"A", "B"}));
        ReadyAfterPrefetch readyAfterPrefetch3 = new ReadyAfterPrefetch(PrefetchableIterators.fromArray((Object[])new String[]{"A", "B"}));
        PrefetchableIterator iterator = PrefetchableIterators.concat((Iterator[])new Iterator[]{readyAfterPrefetch1, readyAfterPrefetch2, readyAfterPrefetch3});
        Assert.assertEquals((long)0L, (long)readyAfterPrefetch1.getNumPrefetchCalls());
        Assert.assertEquals((long)0L, (long)readyAfterPrefetch2.getNumPrefetchCalls());
        Assert.assertEquals((long)0L, (long)readyAfterPrefetch3.getNumPrefetchCalls());
        iterator.prefetch();
        Assert.assertEquals((long)1L, (long)readyAfterPrefetch1.getNumPrefetchCalls());
        Assert.assertEquals((long)0L, (long)readyAfterPrefetch2.getNumPrefetchCalls());
        Assert.assertEquals((long)0L, (long)readyAfterPrefetch3.getNumPrefetchCalls());
        iterator.next();
        iterator.prefetch();
        Assert.assertEquals((long)2L, (long)readyAfterPrefetch1.getNumPrefetchCalls());
        Assert.assertEquals((long)0L, (long)readyAfterPrefetch2.getNumPrefetchCalls());
        Assert.assertEquals((long)0L, (long)readyAfterPrefetch3.getNumPrefetchCalls());
        iterator.next();
        iterator.prefetch();
        Assert.assertEquals((long)3L, (long)readyAfterPrefetch1.getNumPrefetchCalls());
        Assert.assertEquals((long)0L, (long)readyAfterPrefetch2.getNumPrefetchCalls());
        Assert.assertEquals((long)0L, (long)readyAfterPrefetch3.getNumPrefetchCalls());
        iterator.next();
        iterator.prefetch();
        Assert.assertEquals((long)3L, (long)readyAfterPrefetch1.getNumPrefetchCalls());
        Assert.assertEquals((long)1L, (long)readyAfterPrefetch2.getNumPrefetchCalls());
        Assert.assertEquals((long)0L, (long)readyAfterPrefetch3.getNumPrefetchCalls());
        iterator.next();
        iterator.prefetch();
        Assert.assertEquals((long)3L, (long)readyAfterPrefetch1.getNumPrefetchCalls());
        Assert.assertEquals((long)1L, (long)readyAfterPrefetch2.getNumPrefetchCalls());
        Assert.assertEquals((long)1L, (long)readyAfterPrefetch3.getNumPrefetchCalls());
        iterator.next();
        iterator.prefetch();
        Assert.assertEquals((long)3L, (long)readyAfterPrefetch1.getNumPrefetchCalls());
        Assert.assertEquals((long)1L, (long)readyAfterPrefetch2.getNumPrefetchCalls());
        Assert.assertEquals((long)1L, (long)readyAfterPrefetch3.getNumPrefetchCalls());
        iterator.next();
    }

    public static <T> void verifyIsAlwaysReady(PrefetchableIterator<T> iterator) {
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)iterator.isReady());
            iterator.next();
        }
        Assert.assertTrue((boolean)iterator.isReady());
    }

    public static <T> void verifyIterator(Iterator<T> iterator, T ... expected) {
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals(expected[i], iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertThrows(NoSuchElementException.class, () -> iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertThrows(NoSuchElementException.class, () -> iterator.next());
    }

    public static class ReadyAfterPrefetchUntilNext<T>
    extends ReadyAfterPrefetch<T> {
        boolean advancedSincePrefetch;

        public ReadyAfterPrefetchUntilNext(Iterator<T> delegate) {
            super(delegate);
        }

        @Override
        public boolean isReady() {
            return !this.advancedSincePrefetch && super.isReady();
        }

        @Override
        public void prefetch() {
            this.advancedSincePrefetch = false;
            super.prefetch();
        }

        @Override
        public T next() {
            this.advancedSincePrefetch = true;
            return super.next();
        }

        @Override
        public boolean hasNext() {
            this.advancedSincePrefetch = true;
            return super.hasNext();
        }
    }

    public static class ReadyAfterPrefetch<T>
    extends NeverReady<T> {
        public ReadyAfterPrefetch(Iterator<T> delegate) {
            super(delegate);
        }

        @Override
        public boolean isReady() {
            return this.prefetchCalled > 0;
        }
    }

    public static class NeverReady<T>
    implements PrefetchableIterator<T> {
        private final Iterator<T> delegate;
        int prefetchCalled;

        public NeverReady(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        public boolean isReady() {
            return false;
        }

        public void prefetch() {
            ++this.prefetchCalled;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public T next() {
            return this.delegate.next();
        }

        public int getNumPrefetchCalls() {
            return this.prefetchCalled;
        }
    }
}

