/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.util.Iterator;
import org.apache.beam.sdk.fn.stream.PrefetchableIterable;
import org.apache.beam.sdk.fn.stream.PrefetchableIterables;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.sdk.fn.stream.PrefetchableIterators;
import org.apache.beam.sdk.fn.stream.PrefetchableIteratorsTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PrefetchableIterablesTest {
    @Test
    public void testEmptyIterable() {
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.emptyIterable(), new Object[0]);
    }

    @Test
    public void testFromArray() {
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.fromArray((Object[])new String[]{"A", "B", "C"}), new String[]{"A", "B", "C"});
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.fromArray((Object[])new Object[0]), new Object[0]);
    }

    @Test
    public void testLimit() {
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.limit((Iterable)PrefetchableIterables.fromArray((Object[])new Object[0]), (int)0), new Object[0]);
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.limit((Iterable)PrefetchableIterables.fromArray((Object[])new Object[0]), (int)1), new Object[0]);
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.limit((Iterable)PrefetchableIterables.fromArray((Object[])new String[]{"A", "B", "C"}), (int)0), new String[0]);
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.limit((Iterable)PrefetchableIterables.fromArray((Object[])new String[]{"A", "B", "C"}), (int)2), new String[]{"A", "B"});
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.limit((Iterable)PrefetchableIterables.fromArray((Object[])new String[]{"A", "B", "C"}), (int)3), new String[]{"A", "B", "C"});
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.limit((Iterable)PrefetchableIterables.fromArray((Object[])new String[]{"A", "B", "C"}), (int)4), new String[]{"A", "B", "C"});
    }

    @Test
    public void testDefaultPrefetch() {
        PrefetchableIterables.Default<String> iterable = new PrefetchableIterables.Default<String>(){

            protected PrefetchableIterator<String> createIterator() {
                return new PrefetchableIteratorsTest.ReadyAfterPrefetchUntilNext<String>((Iterator<String>)PrefetchableIterators.fromArray((Object[])new String[]{"A", "B", "C"}));
            }
        };
        Assert.assertFalse((boolean)iterable.iterator().isReady());
        iterable.prefetch();
        Assert.assertTrue((boolean)iterable.iterator().isReady());
    }

    @Test
    public void testConcat() {
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.concat((Iterable[])new Iterable[0]), new Object[0]);
        PrefetchableIterable instance = PrefetchableIterables.fromArray((Object[])new String[]{"A", "B"});
        Assert.assertSame((Object)PrefetchableIterables.concat((Iterable[])new Iterable[]{instance}), (Object)instance);
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.concat((Iterable[])new Iterable[]{PrefetchableIterables.fromArray((Object[])new Object[0]), PrefetchableIterables.fromArray((Object[])new Object[0]), PrefetchableIterables.fromArray((Object[])new Object[0])}), new Object[0]);
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.concat((Iterable[])new Iterable[]{PrefetchableIterables.fromArray((Object[])new String[]{"A", "B"}), PrefetchableIterables.fromArray((Object[])new String[0]), PrefetchableIterables.fromArray((Object[])new String[0])}), new String[]{"A", "B"});
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.concat((Iterable[])new Iterable[]{PrefetchableIterables.fromArray((Object[])new String[0]), PrefetchableIterables.fromArray((Object[])new String[]{"C", "D"}), PrefetchableIterables.fromArray((Object[])new String[0])}), new String[]{"C", "D"});
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.concat((Iterable[])new Iterable[]{PrefetchableIterables.fromArray((Object[])new String[0]), PrefetchableIterables.fromArray((Object[])new String[0]), PrefetchableIterables.fromArray((Object[])new String[]{"E", "F"})}), new String[]{"E", "F"});
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.concat((Iterable[])new Iterable[]{PrefetchableIterables.fromArray((Object[])new String[0]), PrefetchableIterables.fromArray((Object[])new String[]{"C", "D"}), PrefetchableIterables.fromArray((Object[])new String[]{"E", "F"})}), new String[]{"C", "D", "E", "F"});
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.concat((Iterable[])new Iterable[]{PrefetchableIterables.fromArray((Object[])new String[]{"A", "B"}), PrefetchableIterables.fromArray((Object[])new String[0]), PrefetchableIterables.fromArray((Object[])new String[]{"E", "F"})}), new String[]{"A", "B", "E", "F"});
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.concat((Iterable[])new Iterable[]{PrefetchableIterables.fromArray((Object[])new String[]{"A", "B"}), PrefetchableIterables.fromArray((Object[])new String[]{"C", "D"}), PrefetchableIterables.fromArray((Object[])new String[0])}), new String[]{"A", "B", "C", "D"});
        PrefetchableIterablesTest.verifyIterable(PrefetchableIterables.concat((Iterable[])new Iterable[]{PrefetchableIterables.fromArray((Object[])new String[]{"A", "B"}), PrefetchableIterables.fromArray((Object[])new String[]{"C", "D"}), PrefetchableIterables.fromArray((Object[])new String[]{"E", "F"})}), new String[]{"A", "B", "C", "D", "E", "F"});
    }

    public static <T> void verifyIterable(Iterable<T> iterable, T ... expected) {
        for (int i = 0; i < 3; ++i) {
            PrefetchableIteratorsTest.verifyIterator(iterable.iterator(), expected);
        }
    }
}

