/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import org.apache.beam.sdk.fn.stream.ForwardingClientResponseObserver;
import org.apache.beam.vendor.grpc.v1p54p0.io.grpc.stub.ClientCallStreamObserver;
import org.apache.beam.vendor.grpc.v1p54p0.io.grpc.stub.StreamObserver;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class ForwardingClientResponseObserverTest {
    @Test
    public void testCallsAreForwardedAndOnReadyHandlerBoundSuccess() {
        StreamObserver delegateObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        ClientCallStreamObserver callStreamObserver = (ClientCallStreamObserver)Mockito.mock(ClientCallStreamObserver.class);
        Runnable onReadyHandler = () -> {};
        ForwardingClientResponseObserver observer = ForwardingClientResponseObserver.create((StreamObserver)delegateObserver, (Runnable)onReadyHandler);
        observer.onNext((Object)"A");
        ((StreamObserver)Mockito.verify((Object)delegateObserver)).onNext((Object)"A");
        observer.onCompleted();
        ((StreamObserver)Mockito.verify((Object)delegateObserver)).onCompleted();
        observer.beforeStart(callStreamObserver);
        ((ClientCallStreamObserver)Mockito.verify((Object)callStreamObserver)).setOnReadyHandler(onReadyHandler);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegateObserver, callStreamObserver});
    }

    @Test
    public void testCallsAreForwardedAndOnReadyHandlerBoundSuccessWithDoneHandler() {
        StreamObserver delegateObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        ClientCallStreamObserver callStreamObserver = (ClientCallStreamObserver)Mockito.mock(ClientCallStreamObserver.class);
        Runnable onReadyHandler = () -> {};
        Runnable onDoneHandler = (Runnable)Mockito.mock(Runnable.class);
        ForwardingClientResponseObserver observer = ForwardingClientResponseObserver.create((StreamObserver)delegateObserver, (Runnable)onReadyHandler, (Runnable)onDoneHandler);
        observer.onNext((Object)"A");
        ((StreamObserver)Mockito.verify((Object)delegateObserver)).onNext((Object)"A");
        observer.onCompleted();
        ((StreamObserver)Mockito.verify((Object)delegateObserver)).onCompleted();
        observer.beforeStart(callStreamObserver);
        ((ClientCallStreamObserver)Mockito.verify((Object)callStreamObserver)).setOnReadyHandler(onReadyHandler);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegateObserver, callStreamObserver});
        ((Runnable)Mockito.verify((Object)onDoneHandler)).run();
    }

    @Test
    public void testCallsAreForwardedAndOnReadyHandlerBoundError() {
        StreamObserver delegateObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        ClientCallStreamObserver callStreamObserver = (ClientCallStreamObserver)Mockito.mock(ClientCallStreamObserver.class);
        Runnable onReadyHandler = () -> {};
        Runnable onDoneHandler = (Runnable)Mockito.mock(Runnable.class);
        ForwardingClientResponseObserver observer = ForwardingClientResponseObserver.create((StreamObserver)delegateObserver, (Runnable)onReadyHandler, (Runnable)onDoneHandler);
        observer.onNext((Object)"A");
        ((StreamObserver)Mockito.verify((Object)delegateObserver)).onNext((Object)"A");
        RuntimeException t = new RuntimeException();
        observer.onError((Throwable)t);
        ((StreamObserver)Mockito.verify((Object)delegateObserver)).onError((Throwable)t);
        observer.beforeStart(callStreamObserver);
        ((ClientCallStreamObserver)Mockito.verify((Object)callStreamObserver)).setOnReadyHandler(onReadyHandler);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegateObserver, callStreamObserver});
        ((Runnable)Mockito.verify((Object)onDoneHandler)).run();
    }
}

