/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.fn.data.WeightedList;
import org.apache.beam.sdk.fn.stream.DataStreams;
import org.apache.beam.sdk.fn.stream.PrefetchableIterators;
import org.apache.beam.sdk.fn.stream.PrefetchableIteratorsTest;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.CountingOutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=Enclosed.class)
public class DataStreamsTest {

    @RunWith(value=JUnit4.class)
    public static class ElementDelimitedOutputStreamTest {
        @Test
        public void testNothingWritten() throws Exception {
            ArrayList output = new ArrayList();
            DataStreams.ElementDelimitedOutputStream outputStream = new DataStreams.ElementDelimitedOutputStream(output::add, 3);
            outputStream.close();
            MatcherAssert.assertThat(output, (Matcher)IsCollectionWithSize.hasSize((int)0));
        }

        @Test
        public void testEmptyElementsArePadded() throws Exception {
            ArrayList output = new ArrayList();
            DataStreams.ElementDelimitedOutputStream outputStream = new DataStreams.ElementDelimitedOutputStream(output::add, 3);
            outputStream.delimitElement();
            outputStream.delimitElement();
            outputStream.delimitElement();
            outputStream.delimitElement();
            outputStream.delimitElement();
            outputStream.close();
            MatcherAssert.assertThat(output, (Matcher)Matchers.contains((Object[])new ByteString[]{ByteString.copyFrom((byte[])new byte[3]), ByteString.copyFrom((byte[])new byte[2])}));
        }

        @Test
        public void testNonEmptyElementsAreChunked() throws Exception {
            ArrayList output = new ArrayList();
            DataStreams.ElementDelimitedOutputStream outputStream = new DataStreams.ElementDelimitedOutputStream(output::add, 3);
            outputStream.write(new byte[]{1, 2});
            outputStream.delimitElement();
            outputStream.write(new byte[]{3, 4, 5, 6, 7, 8});
            outputStream.delimitElement();
            outputStream.write(9);
            outputStream.delimitElement();
            outputStream.close();
            MatcherAssert.assertThat(output, (Matcher)Matchers.contains((Object[])new ByteString[]{ByteString.copyFrom((byte[])new byte[]{1, 2, 3}), ByteString.copyFrom((byte[])new byte[]{4, 5, 6}), ByteString.copyFrom((byte[])new byte[]{7, 8, 9})}));
        }
    }

    @RunWith(value=JUnit4.class)
    public static class DataStreamDecoderTest {
        @Rule
        public ExpectedException thrown = ExpectedException.none();

        @Test
        public void testEmptyInputStream() throws Exception {
            this.testDecoderWith((Coder)StringUtf8Coder.of(), (T[])new String[0]);
        }

        @Test
        public void testNonEmptyInputStream() throws Exception {
            this.testDecoderWith((Coder)StringUtf8Coder.of(), (T[])new String[]{"A", "BC", "DEF", "GHIJ"});
        }

        @Test
        public void testNonEmptyInputStreamWithZeroLengthEncoding() throws Exception {
            CountingOutputStream countingOutputStream = new CountingOutputStream(ByteStreams.nullOutputStream());
            GlobalWindow.Coder.INSTANCE.encode(GlobalWindow.INSTANCE, (OutputStream)countingOutputStream);
            Assume.assumeTrue((countingOutputStream.getCount() == 0L ? 1 : 0) != 0);
            this.testDecoderWith((Coder)GlobalWindow.Coder.INSTANCE, (T[])new GlobalWindow[]{GlobalWindow.INSTANCE, GlobalWindow.INSTANCE});
        }

        @Test
        public void testPrefetch() throws Exception {
            ArrayList<ByteString> encodings = new ArrayList<ByteString>();
            encodings.add(this.encode("A", "BC"));
            encodings.add(ByteString.EMPTY);
            encodings.add(this.encode("DEF", "GHIJ"));
            PrefetchableIteratorsTest.ReadyAfterPrefetchUntilNext iterator = new PrefetchableIteratorsTest.ReadyAfterPrefetchUntilNext(encodings.iterator());
            DataStreams.DataStreamDecoder decoder = new DataStreams.DataStreamDecoder((Coder)StringUtf8Coder.of(), iterator);
            Assert.assertFalse((boolean)decoder.isReady());
            decoder.prefetch();
            Assert.assertTrue((boolean)decoder.isReady());
            Assert.assertEquals((long)1L, (long)iterator.getNumPrefetchCalls());
            decoder.next();
            Assert.assertTrue((boolean)decoder.isReady());
            decoder.prefetch();
            Assert.assertEquals((long)1L, (long)iterator.getNumPrefetchCalls());
            decoder.next();
            Assert.assertFalse((boolean)decoder.isReady());
            decoder.prefetch();
            Assert.assertEquals((long)2L, (long)iterator.getNumPrefetchCalls());
            Assert.assertFalse((boolean)decoder.isReady());
            decoder.prefetch();
            Assert.assertEquals((long)3L, (long)iterator.getNumPrefetchCalls());
            Assert.assertTrue((boolean)decoder.isReady());
        }

        @Test
        public void testDecodeFromChunkBoundaryToChunkBoundary() throws Exception {
            ByteString multipleElementsToSplit = this.encode("B", "BigElementC");
            ByteString singleElementToSplit = this.encode("BigElementG");
            DataStreams.DataStreamDecoder decoder = new DataStreams.DataStreamDecoder((Coder)StringUtf8Coder.of(), new PrefetchableIteratorsTest.ReadyAfterPrefetchUntilNext(Iterators.forArray((Object[])new ByteString[]{this.encode("A"), multipleElementsToSplit.substring(0, multipleElementsToSplit.size() - 1), multipleElementsToSplit.substring(multipleElementsToSplit.size() - 1), this.encode("D"), this.encode(new String[0]), this.encode("E", "F"), singleElementToSplit.substring(0, singleElementToSplit.size() - 1), singleElementToSplit.substring(singleElementToSplit.size() - 1)})));
            WeightedList weightedListA = decoder.decodeFromChunkBoundaryToChunkBoundary();
            MatcherAssert.assertThat((Object)weightedListA.getBacking(), (Matcher)Matchers.contains((Object[])new String[]{"A"}));
            MatcherAssert.assertThat((Object)weightedListA.getWeight(), (Matcher)Matchers.equalTo((Object)10L));
            WeightedList weightedListBC = decoder.decodeFromChunkBoundaryToChunkBoundary();
            MatcherAssert.assertThat((Object)weightedListBC.getBacking(), (Matcher)Matchers.contains((Object[])new String[]{"B", "BigElementC"}));
            MatcherAssert.assertThat((Object)weightedListBC.getWeight(), (Matcher)Matchers.equalTo((Object)29L));
            MatcherAssert.assertThat((Object)decoder.decodeFromChunkBoundaryToChunkBoundary().getBacking(), (Matcher)Matchers.contains((Object[])new String[]{"D"}));
            MatcherAssert.assertThat((Object)decoder.decodeFromChunkBoundaryToChunkBoundary().getBacking(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)decoder.decodeFromChunkBoundaryToChunkBoundary().getBacking(), (Matcher)Matchers.contains((Object[])new String[]{"E", "F"}));
            MatcherAssert.assertThat((Object)decoder.decodeFromChunkBoundaryToChunkBoundary().getBacking(), (Matcher)Matchers.contains((Object[])new String[]{"BigElementG"}));
            Assert.assertFalse((boolean)decoder.hasNext());
        }

        private ByteString encode(String ... values) throws IOException {
            ByteStringOutputStream out = new ByteStringOutputStream();
            for (String value : values) {
                StringUtf8Coder.of().encode(value, (OutputStream)out);
            }
            return out.toByteString();
        }

        private <T> void testDecoderWith(Coder<T> coder, T ... expected) throws IOException {
            ByteStringOutputStream output = new ByteStringOutputStream();
            for (T value : expected) {
                int size = output.size();
                coder.encode(value, (OutputStream)output);
                if (output.size() - size != 0) continue;
                output.write(0);
            }
            this.testDecoderWith(coder, expected, Arrays.asList(output.toByteString()));
            this.testDecoderWith(coder, expected, Arrays.asList(ByteString.EMPTY, output.toByteString()));
            this.testDecoderWith(coder, expected, Arrays.asList(output.toByteString(), ByteString.EMPTY));
        }

        private <T> void testDecoderWith(Coder<T> coder, T[] expected, List<ByteString> encoded) {
            DataStreams.DataStreamDecoder decoder = new DataStreams.DataStreamDecoder(coder, PrefetchableIterators.maybePrefetchable(encoded.iterator()));
            Object[] actual = Iterators.toArray((Iterator)decoder, Object.class);
            Assert.assertArrayEquals((Object[])expected, (Object[])actual);
            Assert.assertFalse((boolean)decoder.hasNext());
            Assert.assertFalse((boolean)decoder.hasNext());
            this.thrown.expect(NoSuchElementException.class);
            decoder.next();
        }
    }
}

