/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.sdk.fn.stream.AdvancingPhaser;
import org.apache.beam.sdk.fn.stream.BufferingStreamObserver;
import org.apache.beam.sdk.fn.test.TestExecutors;
import org.apache.beam.sdk.fn.test.TestStreams;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BufferingStreamObserverTest {
    @Rule
    public TestExecutors.TestExecutorService executor = TestExecutors.from((ExecutorService)Executors.newCachedThreadPool());

    @Test
    public void testThreadSafety() throws Exception {
        ArrayList onNextValues = new ArrayList();
        AdvancingPhaser phaser = new AdvancingPhaser(1);
        AtomicBoolean isCriticalSectionShared = new AtomicBoolean();
        BufferingStreamObserver streamObserver = new BufferingStreamObserver((Phaser)phaser, TestStreams.withOnNext(t -> {
            Assert.assertFalse((boolean)isCriticalSectionShared.getAndSet(true));
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
            onNextValues.add(t);
            Assert.assertTrue((boolean)isCriticalSectionShared.getAndSet(false));
        }).build(), (ExecutorService)this.executor, 3);
        ImmutableList prefixes = ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4");
        ArrayList<Callable<String>> tasks = new ArrayList<Callable<String>>();
        for (Object prefix : prefixes) {
            tasks.add(() -> BufferingStreamObserverTest.lambda$testThreadSafety$1(streamObserver, (String)prefix));
        }
        List results = this.executor.invokeAll(tasks);
        for (Future result : results) {
            result.get();
        }
        streamObserver.onCompleted();
        int[] prefixesIndex = new int[prefixes.size()];
        Assert.assertEquals((long)50L, (long)onNextValues.size());
        for (String onNextValue : onNextValues) {
            int prefix = Integer.parseInt(onNextValue.substring(0, 1));
            int suffix = Integer.parseInt(onNextValue.substring(1, 2));
            Assert.assertEquals((long)prefixesIndex[prefix], (long)suffix);
            int n = prefix;
            prefixesIndex[n] = prefixesIndex[n] + 1;
        }
    }

    @Test
    public void testIsReadyIsHonored() throws Exception {
        AdvancingPhaser phaser = new AdvancingPhaser(1);
        AtomicBoolean elementsAllowed = new AtomicBoolean();
        BufferingStreamObserver streamObserver = new BufferingStreamObserver((Phaser)phaser, TestStreams.withOnNext(t -> Assert.assertTrue((boolean)elementsAllowed.get())).withIsReady(elementsAllowed::get).build(), (ExecutorService)this.executor, 3);
        ArrayList<Future> results = new ArrayList<Future>();
        for (String prefix : ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4")) {
            results.add(this.executor.submit(() -> {
                for (int i = 0; i < 10; ++i) {
                    streamObserver.onNext((Object)(prefix + i));
                }
                return prefix;
            }));
        }
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        elementsAllowed.set(true);
        phaser.arrive();
        for (Future result : results) {
            result.get();
        }
        streamObserver.onCompleted();
    }

    private static /* synthetic */ String lambda$testThreadSafety$1(BufferingStreamObserver streamObserver, String prefix) throws Exception {
        for (int i = 0; i < 10; ++i) {
            streamObserver.onNext((Object)(prefix + i));
        }
        return prefix;
    }
}

