/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.splittabledofn;

import java.util.ArrayList;
import org.apache.beam.sdk.fn.splittabledofn.RestrictionTrackers;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RestrictionTrackersTest {
    @Test
    public void testObservingClaims() {
        RestrictionTracker observedTracker = new RestrictionTracker(){

            public boolean tryClaim(Object position) {
                return "goodClaim".equals(position);
            }

            public Object currentRestriction() {
                throw new UnsupportedOperationException();
            }

            public SplitResult<Object> trySplit(double fractionOfRemainder) {
                throw new UnsupportedOperationException();
            }

            public void checkDone() throws IllegalStateException {
                throw new UnsupportedOperationException();
            }

            public RestrictionTracker.IsBounded isBounded() {
                return RestrictionTracker.IsBounded.BOUNDED;
            }
        };
        final ArrayList positionsObserved = new ArrayList();
        RestrictionTrackers.ClaimObserver<String> observer = new RestrictionTrackers.ClaimObserver<String>(){

            public void onClaimed(String position) {
                positionsObserved.add(position);
                Assert.assertEquals((Object)"goodClaim", (Object)position);
            }

            public void onClaimFailed(String position) {
                positionsObserved.add(position);
            }
        };
        RestrictionTracker observingTracker = RestrictionTrackers.observe((RestrictionTracker)observedTracker, (RestrictionTrackers.ClaimObserver)observer);
        observingTracker.tryClaim((Object)"goodClaim");
        observingTracker.tryClaim((Object)"badClaim");
        MatcherAssert.assertThat(positionsObserved, (Matcher)Matchers.contains((Object[])new String[]{"goodClaim", "badClaim"}));
    }

    @Test
    public void testClaimObserversMaintainBacklogInterfaces() {
        RestrictionTracker hasSize = RestrictionTrackers.observe((RestrictionTracker)new RestrictionTrackerWithProgress(), null);
        MatcherAssert.assertThat((Object)hasSize, (Matcher)Matchers.instanceOf(RestrictionTracker.HasProgress.class));
    }

    private static class RestrictionTrackerWithProgress
    extends RestrictionTracker<Object, Object>
    implements RestrictionTracker.HasProgress {
        private RestrictionTrackerWithProgress() {
        }

        public RestrictionTracker.Progress getProgress() {
            return RestrictionTracker.Progress.from((double)2.0, (double)3.0);
        }

        public boolean tryClaim(Object position) {
            return false;
        }

        public Object currentRestriction() {
            return null;
        }

        public SplitResult<Object> trySplit(double fractionOfRemainder) {
            return null;
        }

        public void checkDone() throws IllegalStateException {
        }

        public RestrictionTracker.IsBounded isBounded() {
            return RestrictionTracker.IsBounded.BOUNDED;
        }
    }
}

