/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.fn.data.RemoteGrpcPortRead;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.InvalidProtocolBufferException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RemoteGrpcPortReadTest {
    @Test
    public void getPortSucceeds() {
        BeamFnApi.RemoteGrpcPort port = BeamFnApi.RemoteGrpcPort.newBuilder().setApiServiceDescriptor(Endpoints.ApiServiceDescriptor.newBuilder().setUrl("foo").setAuthentication(Endpoints.AuthenticationSpec.getDefaultInstance()).build()).build();
        RemoteGrpcPortRead read = RemoteGrpcPortRead.readFromPort((BeamFnApi.RemoteGrpcPort)port, (String)"myPort");
        MatcherAssert.assertThat((Object)read.getPort(), (Matcher)Matchers.equalTo((Object)port));
    }

    @Test
    public void toFromPTransform() throws InvalidProtocolBufferException {
        BeamFnApi.RemoteGrpcPort port = BeamFnApi.RemoteGrpcPort.newBuilder().setApiServiceDescriptor(Endpoints.ApiServiceDescriptor.newBuilder().setUrl("foo").setAuthentication(Endpoints.AuthenticationSpec.getDefaultInstance()).build()).build();
        RemoteGrpcPortRead read = RemoteGrpcPortRead.readFromPort((BeamFnApi.RemoteGrpcPort)port, (String)"myPort");
        RunnerApi.PTransform ptransform = RunnerApi.PTransform.parseFrom((byte[])read.toPTransform().toByteArray());
        RemoteGrpcPortRead serDeRead = RemoteGrpcPortRead.fromPTransform((RunnerApi.PTransform)ptransform);
        MatcherAssert.assertThat((Object)serDeRead, (Matcher)Matchers.equalTo((Object)read));
        MatcherAssert.assertThat((Object)serDeRead.getPort(), (Matcher)Matchers.equalTo((Object)read.getPort()));
        MatcherAssert.assertThat((Object)serDeRead.toPTransform(), (Matcher)Matchers.equalTo((Object)ptransform));
    }
}

