/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn;

import com.google.auto.service.AutoService;
import org.apache.beam.sdk.fn.JvmInitializers;
import org.apache.beam.sdk.harness.JvmInitializer;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.TestPipeline;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.SystemOutRule;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class JvmInitializersTest {
    @Rule
    public ExpectedLogs expectedLogs = ExpectedLogs.none(JvmInitializers.class);
    @Rule
    public SystemOutRule systemOutRule = new SystemOutRule().enableLog();
    private static Boolean onStartupRan;
    private static Boolean beforeProcessingRan;
    private static PipelineOptions receivedOptions;

    @Before
    public void setUp() {
        onStartupRan = false;
        beforeProcessingRan = false;
        receivedOptions = null;
    }

    @Test
    public void runOnStartup_runsInitializers() {
        JvmInitializers.runOnStartup();
        Assert.assertTrue((boolean)onStartupRan);
        MatcherAssert.assertThat((Object)this.systemOutRule.getLog(), (Matcher)StringContains.containsString((String)"Running JvmInitializer#onStartup"));
    }

    @Test
    public void runBeforeProcessing_runsInitializersWithOptions() {
        PipelineOptions options = TestPipeline.testingPipelineOptions();
        JvmInitializers.runBeforeProcessing((PipelineOptions)options);
        Assert.assertTrue((boolean)beforeProcessingRan);
        Assert.assertEquals((Object)options, (Object)receivedOptions);
        this.expectedLogs.verifyInfo("Running JvmInitializer#beforeProcessing");
    }

    @AutoService(value={JvmInitializer.class})
    public static class TestInitializer
    implements JvmInitializer {
        public void onStartup() {
            onStartupRan = true;
        }

        public void beforeProcessing(PipelineOptions options) {
            beforeProcessingRan = true;
            receivedOptions = options;
        }
    }
}

