/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn;

import org.apache.beam.sdk.fn.IdGenerator;
import org.apache.beam.sdk.fn.IdGenerators;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IdGeneratorsTest {
    @Test
    public void incrementing() {
        IdGenerator gen = IdGenerators.incrementingLongs();
        MatcherAssert.assertThat((Object)gen.getId(), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)gen.getId(), (Matcher)Matchers.equalTo((Object)"2"));
    }

    @Test
    public void incrementingIndependent() {
        IdGenerator gen = IdGenerators.incrementingLongs();
        IdGenerator otherGen = IdGenerators.incrementingLongs();
        MatcherAssert.assertThat((Object)gen.getId(), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)gen.getId(), (Matcher)Matchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)otherGen.getId(), (Matcher)Matchers.equalTo((Object)"1"));
    }

    @Test
    public void decrementing() {
        IdGenerator gen = IdGenerators.decrementingLongs();
        MatcherAssert.assertThat((Object)gen.getId(), (Matcher)Matchers.equalTo((Object)"-1"));
        MatcherAssert.assertThat((Object)gen.getId(), (Matcher)Matchers.equalTo((Object)"-2"));
    }

    @Test
    public void decrementingIndependent() {
        IdGenerator gen = IdGenerators.decrementingLongs();
        IdGenerator otherGen = IdGenerators.decrementingLongs();
        MatcherAssert.assertThat((Object)gen.getId(), (Matcher)Matchers.equalTo((Object)"-1"));
        MatcherAssert.assertThat((Object)gen.getId(), (Matcher)Matchers.equalTo((Object)"-2"));
        MatcherAssert.assertThat((Object)otherGen.getId(), (Matcher)Matchers.equalTo((Object)"-1"));
    }
}

