/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.test;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.sdk.fn.test.TestStreams;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestStreamsTest {
    @Test
    public void testOnNextIsCalled() {
        AtomicBoolean onNextWasCalled = new AtomicBoolean();
        TestStreams.withOnNext(onNextWasCalled::set).build().onNext((Object)true);
        Assert.assertTrue((boolean)onNextWasCalled.get());
    }

    @Test
    public void testIsReadyIsCalled() {
        AtomicBoolean isReadyWasCalled = new AtomicBoolean();
        Assert.assertFalse((boolean)TestStreams.withOnNext(null).withIsReady(() -> isReadyWasCalled.getAndSet(true)).build().isReady());
        Assert.assertTrue((boolean)isReadyWasCalled.get());
    }

    @Test
    public void testOnCompletedIsCalled() {
        AtomicBoolean onCompletedWasCalled = new AtomicBoolean();
        TestStreams.withOnNext(null).withOnCompleted(() -> onCompletedWasCalled.set(true)).build().onCompleted();
        Assert.assertTrue((boolean)onCompletedWasCalled.get());
    }

    @Test
    public void testOnErrorRunnableIsCalled() {
        RuntimeException throwable = new RuntimeException();
        AtomicBoolean onErrorWasCalled = new AtomicBoolean();
        TestStreams.withOnNext(null).withOnError(() -> onErrorWasCalled.set(true)).build().onError((Throwable)throwable);
        Assert.assertTrue((boolean)onErrorWasCalled.get());
    }

    @Test
    public void testOnErrorConsumerIsCalled() {
        RuntimeException throwable = new RuntimeException();
        ArrayList onErrorWasCalled = new ArrayList();
        TestStreams.withOnNext(null).withOnError(onErrorWasCalled::add).build().onError((Throwable)throwable);
        Assert.assertThat(onErrorWasCalled, (Matcher)Matchers.contains((Object[])new Throwable[]{throwable}));
    }
}

