/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.test;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.sdk.fn.test.TestExecutors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.model.Statement;

@RunWith(value=JUnit4.class)
public class TestExecutorsTest {
    @Test
    public void testSuccessfulTermination() throws @UnknownKeyFor @NonNull @Initialized Throwable {
        ExecutorService service = Executors.newSingleThreadExecutor();
        final TestExecutors.TestExecutorService testService = TestExecutors.from((ExecutorService)service);
        final AtomicBoolean taskRan = new AtomicBoolean();
        testService.apply(new Statement(){

            public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                testService.submit(() -> taskRan.set(true)).get();
            }
        }, null).evaluate();
        Assert.assertTrue((boolean)service.isTerminated());
        Assert.assertTrue((boolean)taskRan.get());
    }

    @Test
    public void testTaskBlocksForeverCausesFailure() throws @UnknownKeyFor @NonNull @Initialized Throwable {
        ExecutorService service = Executors.newSingleThreadExecutor();
        final TestExecutors.TestExecutorService testService = TestExecutors.from((ExecutorService)service);
        final AtomicBoolean taskStarted = new AtomicBoolean();
        final AtomicBoolean taskWasInterrupted = new AtomicBoolean();
        try {
            testService.apply(new Statement(){

                public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    testService.submit(this::taskToRun);
                }

                private void taskToRun() {
                    taskStarted.set(true);
                    try {
                        while (true) {
                            Thread.sleep(10000L);
                        }
                    }
                    catch (InterruptedException e) {
                        taskWasInterrupted.set(true);
                        return;
                    }
                }
            }, null).evaluate();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals(IllegalStateException.class, e.getClass());
            Assert.assertEquals((Object)"Test executor failed to shutdown cleanly.", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)service.isShutdown());
    }

    @Test
    public void testStatementFailurePropagatedCleanly() throws @UnknownKeyFor @NonNull @Initialized Throwable {
        ExecutorService service = Executors.newSingleThreadExecutor();
        TestExecutors.TestExecutorService testService = TestExecutors.from((ExecutorService)service);
        final RuntimeException exceptionToThrow = new RuntimeException();
        try {
            testService.apply(new Statement(){

                public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    throw exceptionToThrow;
                }
            }, null).evaluate();
            Assert.fail();
        }
        catch (RuntimeException thrownException) {
            Assert.assertSame((Object)exceptionToThrow, (Object)thrownException);
        }
        Assert.assertTrue((boolean)service.isShutdown());
    }

    @Test
    public void testStatementFailurePropagatedWhenExecutorServiceFailingToTerminate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
        ExecutorService service = Executors.newSingleThreadExecutor();
        final TestExecutors.TestExecutorService testService = TestExecutors.from((ExecutorService)service);
        final AtomicBoolean taskStarted = new AtomicBoolean();
        final AtomicBoolean taskWasInterrupted = new AtomicBoolean();
        final RuntimeException exceptionToThrow = new RuntimeException();
        try {
            testService.apply(new Statement(){

                public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    testService.submit(this::taskToRun);
                    throw exceptionToThrow;
                }

                private void taskToRun() {
                    taskStarted.set(true);
                    try {
                        while (true) {
                            Thread.sleep(10000L);
                        }
                    }
                    catch (InterruptedException e) {
                        taskWasInterrupted.set(true);
                        return;
                    }
                }
            }, null).evaluate();
            Assert.fail();
        }
        catch (RuntimeException thrownException) {
            Assert.assertSame((Object)exceptionToThrow, (Object)thrownException);
            Assert.assertEquals((long)1L, (long)exceptionToThrow.getSuppressed().length);
            Assert.assertEquals(IllegalStateException.class, exceptionToThrow.getSuppressed()[0].getClass());
            Assert.assertEquals((Object)"Test executor failed to shutdown cleanly.", (Object)exceptionToThrow.getSuppressed()[0].getMessage());
        }
        Assert.assertTrue((boolean)service.isShutdown());
    }
}

