/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.beam.sdk.fn.stream.BufferingStreamObserver;
import org.apache.beam.sdk.fn.stream.DirectStreamObserver;
import org.apache.beam.sdk.fn.stream.ForwardingClientResponseObserver;
import org.apache.beam.sdk.fn.stream.OutboundObserverFactory;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.CallStreamObserver;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.StreamObserver;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class OutboundObserverFactoryTest {
    @Mock
    private @UnknownKeyFor @NonNull @Initialized StreamObserver<@UnknownKeyFor @NonNull @Initialized Integer> mockRequestObserver;
    @Mock
    private @UnknownKeyFor @NonNull @Initialized CallStreamObserver<@UnknownKeyFor @NonNull @Initialized String> mockResponseObserver;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testDefaultInstantiation() {
        StreamObserver observer = OutboundObserverFactory.clientDirect().outboundObserverFor(this.fakeFactory(), this.mockRequestObserver);
        Assert.assertThat((Object)observer, (Matcher)Matchers.instanceOf(DirectStreamObserver.class));
    }

    @Test
    public void testBufferedStreamInstantiation() {
        StreamObserver observer = OutboundObserverFactory.clientBuffered((ExecutorService)Executors.newSingleThreadExecutor()).outboundObserverFor(this.fakeFactory(), this.mockRequestObserver);
        Assert.assertThat((Object)observer, (Matcher)Matchers.instanceOf(BufferingStreamObserver.class));
    }

    @Test
    public void testBufferedStreamWithLimitInstantiation() {
        StreamObserver observer = OutboundObserverFactory.clientBuffered((ExecutorService)Executors.newSingleThreadExecutor(), (int)1).outboundObserverFor(this.fakeFactory(), this.mockRequestObserver);
        Assert.assertThat((Object)observer, (Matcher)Matchers.instanceOf(BufferingStreamObserver.class));
        Assert.assertEquals((long)1L, (long)((BufferingStreamObserver)observer).getBufferSize());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory.BasicFactory<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized String> fakeFactory() {
        return inboundObserver -> {
            Assert.assertThat((Object)inboundObserver, (Matcher)Matchers.instanceOf(ForwardingClientResponseObserver.class));
            return this.mockResponseObserver;
        };
    }
}

