/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.fn.stream.DataStreams;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CountingOutputStream;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.SettableFuture;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

public class DataStreamsTest {

    @RunWith(value=JUnit4.class)
    public static class ElementDelimitedOutputStreamTest {
        @Test
        public void testNothingWritten() throws @UnknownKeyFor @NonNull @Initialized Exception {
            ArrayList output = new ArrayList();
            DataStreams.ElementDelimitedOutputStream outputStream = new DataStreams.ElementDelimitedOutputStream(output::add, 3);
            outputStream.close();
            Assert.assertThat(output, (Matcher)IsCollectionWithSize.hasSize((int)0));
        }

        @Test
        public void testEmptyElementsArePadded() throws @UnknownKeyFor @NonNull @Initialized Exception {
            ArrayList output = new ArrayList();
            DataStreams.ElementDelimitedOutputStream outputStream = new DataStreams.ElementDelimitedOutputStream(output::add, 3);
            outputStream.delimitElement();
            outputStream.delimitElement();
            outputStream.delimitElement();
            outputStream.delimitElement();
            outputStream.delimitElement();
            outputStream.close();
            Assert.assertThat(output, (Matcher)Matchers.contains((Object[])new ByteString[]{ByteString.copyFrom((byte[])new byte[3]), ByteString.copyFrom((byte[])new byte[2])}));
        }

        @Test
        public void testNonEmptyElementsAreChunked() throws @UnknownKeyFor @NonNull @Initialized Exception {
            ArrayList output = new ArrayList();
            DataStreams.ElementDelimitedOutputStream outputStream = new DataStreams.ElementDelimitedOutputStream(output::add, 3);
            outputStream.write(new byte[]{1, 2});
            outputStream.delimitElement();
            outputStream.write(new byte[]{3, 4, 5, 6, 7, 8});
            outputStream.delimitElement();
            outputStream.write(9);
            outputStream.delimitElement();
            outputStream.close();
            Assert.assertThat(output, (Matcher)Matchers.contains((Object[])new ByteString[]{ByteString.copyFrom((byte[])new byte[]{1, 2, 3}), ByteString.copyFrom((byte[])new byte[]{4, 5, 6}), ByteString.copyFrom((byte[])new byte[]{7, 8, 9})}));
        }
    }

    @RunWith(value=JUnit4.class)
    public static class DataStreamDecoderTest {
        @Rule
        public @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();

        @Test
        public void testEmptyInputStream() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.testDecoderWith((Coder)StringUtf8Coder.of(), (T[])new String[0]);
        }

        @Test
        public void testNonEmptyInputStream() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.testDecoderWith((Coder)StringUtf8Coder.of(), (T[])new String[]{"A", "BC", "DEF", "GHIJ"});
        }

        @Test
        public void testNonEmptyInputStreamWithZeroLengthCoder() throws @UnknownKeyFor @NonNull @Initialized Exception {
            CountingOutputStream countingOutputStream = new CountingOutputStream(ByteStreams.nullOutputStream());
            GlobalWindow.Coder.INSTANCE.encode(GlobalWindow.INSTANCE, (OutputStream)countingOutputStream);
            Assume.assumeTrue((countingOutputStream.getCount() == 0L ? 1 : 0) != 0);
            this.testDecoderWith((Coder)GlobalWindow.Coder.INSTANCE, (T[])new GlobalWindow[]{GlobalWindow.INSTANCE, GlobalWindow.INSTANCE});
        }

        private <T> void testDecoderWith(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T ... expected) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (T value : expected) {
                int size = baos.size();
                coder.encode(value, (OutputStream)baos);
                if (baos.size() - size != 0) continue;
                baos.write(0);
            }
            DataStreams.DataStreamDecoder decoder = new DataStreams.DataStreamDecoder(coder, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
            Object[] actual = Iterators.toArray((Iterator)decoder, Object.class);
            Assert.assertArrayEquals((Object[])expected, (Object[])actual);
            Assert.assertFalse((boolean)decoder.hasNext());
            Assert.assertFalse((boolean)decoder.hasNext());
            this.thrown.expect(NoSuchElementException.class);
            decoder.next();
        }
    }

    @RunWith(value=JUnit4.class)
    public static class BlockingQueueIteratorTest {
        @Test(timeout=10000L)
        public void testBlockingQueueIteratorWithoutBlocking() throws @UnknownKeyFor @NonNull @Initialized Exception {
            DataStreams.BlockingQueueIterator iterator = new DataStreams.BlockingQueueIterator(new ArrayBlockingQueue(3));
            iterator.accept((Object)"A");
            iterator.accept((Object)"B");
            iterator.close();
            Assert.assertEquals(Arrays.asList("A", "B"), Arrays.asList((String[])Iterators.toArray((Iterator)iterator, String.class)));
        }

        @Test(timeout=10000L)
        public void testBlockingQueueIteratorWithBlocking() throws @UnknownKeyFor @NonNull @Initialized Exception {
            DataStreams.BlockingQueueIterator iterator = new DataStreams.BlockingQueueIterator(new SynchronousQueue());
            SettableFuture valuesFuture = SettableFuture.create();
            Thread appender = new Thread(() -> valuesFuture.set(Arrays.asList((String[])Iterators.toArray((Iterator)iterator, String.class))));
            appender.start();
            iterator.accept((Object)"A");
            iterator.accept((Object)"B");
            iterator.close();
            Assert.assertEquals(Arrays.asList("A", "B"), (Object)valuesFuture.get());
            appender.join();
        }
    }

    @RunWith(value=JUnit4.class)
    public static class InboundTest {
        private static final @UnknownKeyFor @NonNull @Initialized ByteString BYTES_A = ByteString.copyFromUtf8((String)"TestData");
        private static final @UnknownKeyFor @NonNull @Initialized ByteString BYTES_B = ByteString.copyFromUtf8((String)"SomeOtherTestData");

        @Test
        public void testEmptyRead() throws @UnknownKeyFor @NonNull @Initialized Exception {
            Assert.assertEquals((Object)ByteString.EMPTY, (Object)InboundTest.read(new ByteString[0]));
            Assert.assertEquals((Object)ByteString.EMPTY, (Object)InboundTest.read(ByteString.EMPTY));
            Assert.assertEquals((Object)ByteString.EMPTY, (Object)InboundTest.read(ByteString.EMPTY, ByteString.EMPTY));
        }

        @Test
        public void testRead() throws @UnknownKeyFor @NonNull @Initialized Exception {
            Assert.assertEquals((Object)BYTES_A.concat(BYTES_B), (Object)InboundTest.read(BYTES_A, BYTES_B));
            Assert.assertEquals((Object)BYTES_A.concat(BYTES_B), (Object)InboundTest.read(BYTES_A, ByteString.EMPTY, BYTES_B));
            Assert.assertEquals((Object)BYTES_A.concat(BYTES_B), (Object)InboundTest.read(BYTES_A, BYTES_B, ByteString.EMPTY));
        }

        private static @UnknownKeyFor @NonNull @Initialized ByteString read(ByteString ... bytes) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return ByteString.readFrom((InputStream)DataStreams.inbound(Arrays.asList(bytes).iterator()));
        }
    }
}

