/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.fn.stream.AdvancingPhaser;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AdvancingPhaserTest {
    @Test
    public void testAdvancement() throws @UnknownKeyFor @NonNull @Initialized Exception {
        AdvancingPhaser phaser = new AdvancingPhaser(1);
        int currentPhase = phaser.getPhase();
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.submit(() -> phaser.arrive()).get();
        phaser.awaitAdvance(currentPhase);
        Assert.assertFalse((boolean)phaser.isTerminated());
        service.shutdown();
        if (!service.awaitTermination(10L, TimeUnit.SECONDS)) {
            Assert.assertThat(service.shutdownNow(), (Matcher)IsEmptyCollection.empty());
        }
    }
}

