/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.splittabledofn;

import java.util.ArrayList;
import org.apache.beam.sdk.fn.splittabledofn.RestrictionTrackers;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RestrictionTrackersTest {
    @Test
    public void testObservingClaims() {
        RestrictionTracker observedTracker = new RestrictionTracker(){

            public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized Object position) {
                return "goodClaim".equals(position);
            }

            public @UnknownKeyFor @NonNull @Initialized Object currentRestriction() {
                throw new UnsupportedOperationException();
            }

            public @UnknownKeyFor @NonNull @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized Object> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
                throw new UnsupportedOperationException();
            }

            public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
                throw new UnsupportedOperationException();
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
                return RestrictionTracker.IsBounded.BOUNDED;
            }
        };
        final ArrayList positionsObserved = new ArrayList();
        RestrictionTrackers.ClaimObserver<String> observer = new RestrictionTrackers.ClaimObserver<String>(){

            public void onClaimed(@UnknownKeyFor @NonNull @Initialized String position) {
                positionsObserved.add(position);
                Assert.assertEquals((Object)"goodClaim", (Object)position);
            }

            public void onClaimFailed(@UnknownKeyFor @NonNull @Initialized String position) {
                positionsObserved.add(position);
            }
        };
        RestrictionTracker observingTracker = RestrictionTrackers.observe((RestrictionTracker)observedTracker, (RestrictionTrackers.ClaimObserver)observer);
        observingTracker.tryClaim((Object)"goodClaim");
        observingTracker.tryClaim((Object)"badClaim");
        Assert.assertThat(positionsObserved, (Matcher)Matchers.contains((Object[])new String[]{"goodClaim", "badClaim"}));
    }

    @Test
    public void testClaimObserversMaintainBacklogInterfaces() {
        RestrictionTracker hasSize = RestrictionTrackers.observe((RestrictionTracker)new RestrictionTrackerWithProgress(), null);
        Assert.assertThat((Object)hasSize, (Matcher)Matchers.instanceOf(RestrictionTracker.HasProgress.class));
    }

    private static class RestrictionTrackerWithProgress
    extends RestrictionTracker<Object, Object>
    implements RestrictionTracker.HasProgress {
        private RestrictionTrackerWithProgress() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
            return RestrictionTracker.Progress.from((double)2.0, (double)3.0);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized Object position) {
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized Object currentRestriction() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized Object> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
            return null;
        }

        public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
            return RestrictionTracker.IsBounded.BOUNDED;
        }
    }
}

