/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.fn.data.RemoteGrpcPortWrite;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.InvalidProtocolBufferException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RemoteGrpcPortWriteTest {
    @Test
    public void getPortSucceeds() {
        BeamFnApi.RemoteGrpcPort port = BeamFnApi.RemoteGrpcPort.newBuilder().setApiServiceDescriptor(Endpoints.ApiServiceDescriptor.newBuilder().setUrl("foo").setAuthentication(Endpoints.AuthenticationSpec.getDefaultInstance()).build()).build();
        RemoteGrpcPortWrite write = RemoteGrpcPortWrite.writeToPort((String)"myPort", (BeamFnApi.RemoteGrpcPort)port);
        Assert.assertThat((Object)write.getPort(), (Matcher)Matchers.equalTo((Object)port));
    }

    @Test
    public void toFromPTransform() throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        BeamFnApi.RemoteGrpcPort port = BeamFnApi.RemoteGrpcPort.newBuilder().setApiServiceDescriptor(Endpoints.ApiServiceDescriptor.newBuilder().setUrl("foo").setAuthentication(Endpoints.AuthenticationSpec.getDefaultInstance()).build()).build();
        RemoteGrpcPortWrite write = RemoteGrpcPortWrite.writeToPort((String)"myPort", (BeamFnApi.RemoteGrpcPort)port);
        RunnerApi.PTransform ptransform = RunnerApi.PTransform.parseFrom((byte[])write.toPTransform().toByteArray());
        RemoteGrpcPortWrite serDeWrite = RemoteGrpcPortWrite.fromPTransform((RunnerApi.PTransform)ptransform);
        Assert.assertThat((Object)serDeWrite, (Matcher)Matchers.equalTo((Object)write));
        Assert.assertThat((Object)serDeWrite.getPort(), (Matcher)Matchers.equalTo((Object)write.getPort()));
        Assert.assertThat((Object)serDeWrite.toPTransform(), (Matcher)Matchers.equalTo((Object)ptransform));
    }
}

