/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.sdk.fn.data.CompletableFutureInboundDataClient;
import org.apache.beam.sdk.fn.data.InboundDataClient;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CompletableFutureInboundDataClientTest {
    @Rule
    public @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();

    @Test
    public void testComplete() throws @UnknownKeyFor @NonNull @Initialized Exception {
        InboundDataClient client = CompletableFutureInboundDataClient.create();
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)false));
        client.complete();
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)true));
        client.awaitCompletion();
    }

    @Test
    public void testCanceled() throws @UnknownKeyFor @NonNull @Initialized Exception {
        InboundDataClient client = CompletableFutureInboundDataClient.create();
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)false));
        client.cancel();
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)true));
        this.thrown.expect(CancellationException.class);
        client.awaitCompletion();
    }

    @Test
    public void testFailed() throws @UnknownKeyFor @NonNull @Initialized Exception {
        InboundDataClient client = CompletableFutureInboundDataClient.create();
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)false));
        client.fail((Throwable)new UnsupportedOperationException("message"));
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)true));
        this.thrown.expect(ExecutionException.class);
        this.thrown.expectCause(Matchers.isA(UnsupportedOperationException.class));
        this.thrown.expectMessage("message");
        client.awaitCompletion();
    }

    @Test
    public void testCompleteMultithreaded() throws @UnknownKeyFor @NonNull @Initialized Exception {
        InboundDataClient client = CompletableFutureInboundDataClient.create();
        Future<Void> waitingFuture = Executors.newSingleThreadExecutor().submit(() -> {
            client.awaitCompletion();
            return null;
        });
        try {
            waitingFuture.get(50L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        client.complete();
        waitingFuture.get();
    }

    @Test
    public void testCompleteBackingFuture() throws @UnknownKeyFor @NonNull @Initialized Exception {
        CompletableFuture future = new CompletableFuture();
        InboundDataClient client = CompletableFutureInboundDataClient.forBackingFuture(future);
        Assert.assertThat((Object)future.isDone(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)false));
        client.complete();
        Assert.assertThat((Object)future.isDone(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)true));
        client.awaitCompletion();
    }

    @Test
    public void testCancelBackingFuture() throws @UnknownKeyFor @NonNull @Initialized Exception {
        CompletableFuture future = new CompletableFuture();
        InboundDataClient client = CompletableFutureInboundDataClient.forBackingFuture(future);
        Assert.assertThat((Object)future.isDone(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)false));
        client.cancel();
        Assert.assertThat((Object)future.isDone(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)future.isCancelled(), (Matcher)Matchers.is((Object)true));
        this.thrown.expect(CancellationException.class);
        future.get();
    }

    @Test
    public void testFailBackingFuture() throws @UnknownKeyFor @NonNull @Initialized Exception {
        CompletableFuture future = new CompletableFuture();
        InboundDataClient client = CompletableFutureInboundDataClient.forBackingFuture(future);
        Assert.assertThat((Object)future.isDone(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)false));
        client.fail((Throwable)new UnsupportedOperationException("message"));
        Assert.assertThat((Object)client.isDone(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)future.isDone(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)future.isCompletedExceptionally(), (Matcher)Matchers.is((Object)true));
        this.thrown.expect(ExecutionException.class);
        this.thrown.expectCause(Matchers.isA(UnsupportedOperationException.class));
        this.thrown.expectMessage("message");
        client.awaitCompletion();
    }
}

