/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.channel;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.beam.sdk.fn.channel.SocketAddressFactory;
import org.apache.beam.vendor.grpc.v1p26p0.io.netty.channel.unix.DomainSocketAddress;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SocketAddressFactoryTest {
    @Rule
    public @UnknownKeyFor @NonNull @Initialized TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testHostPortSocket() {
        SocketAddress socketAddress = SocketAddressFactory.createFrom((String)"localhost:123");
        Assert.assertThat((Object)socketAddress, (Matcher)Matchers.instanceOf(InetSocketAddress.class));
        Assert.assertEquals((Object)"localhost", (Object)((InetSocketAddress)socketAddress).getHostString());
        Assert.assertEquals((long)123L, (long)((InetSocketAddress)socketAddress).getPort());
    }

    @Test
    public void testDomainSocket() throws @UnknownKeyFor @NonNull @Initialized Exception {
        File tmpFile = this.tmpFolder.newFile();
        SocketAddress socketAddress = SocketAddressFactory.createFrom((String)("unix://" + tmpFile.getAbsolutePath()));
        Assert.assertThat((Object)socketAddress, (Matcher)Matchers.instanceOf(DomainSocketAddress.class));
        Assert.assertEquals((Object)tmpFile.getAbsolutePath(), (Object)((DomainSocketAddress)socketAddress).path());
    }
}

