/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.channel;

import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.sdk.fn.channel.ManagedChannelFactory;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.ManagedChannel;
import org.apache.beam.vendor.grpc.v1p26p0.io.netty.channel.epoll.Epoll;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ManagedChannelFactoryTest {
    @Rule
    public @UnknownKeyFor @NonNull @Initialized TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testDefaultChannel() {
        Endpoints.ApiServiceDescriptor apiServiceDescriptor = Endpoints.ApiServiceDescriptor.newBuilder().setUrl("localhost:123").build();
        ManagedChannel channel = ManagedChannelFactory.createDefault().forDescriptor(apiServiceDescriptor);
        Assert.assertEquals((Object)"localhost:123", (Object)channel.authority());
        channel.shutdownNow();
    }

    @Test
    public void testEpollHostPortChannel() {
        Assume.assumeTrue((boolean)Epoll.isAvailable());
        Endpoints.ApiServiceDescriptor apiServiceDescriptor = Endpoints.ApiServiceDescriptor.newBuilder().setUrl("localhost:123").build();
        ManagedChannel channel = ManagedChannelFactory.createEpoll().forDescriptor(apiServiceDescriptor);
        Assert.assertEquals((Object)"localhost:123", (Object)channel.authority());
        channel.shutdownNow();
    }

    @Test
    public void testEpollDomainSocketChannel() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Assume.assumeTrue((boolean)Epoll.isAvailable());
        Endpoints.ApiServiceDescriptor apiServiceDescriptor = Endpoints.ApiServiceDescriptor.newBuilder().setUrl("unix://" + this.tmpFolder.newFile().getAbsolutePath()).build();
        ManagedChannel channel = ManagedChannelFactory.createEpoll().forDescriptor(apiServiceDescriptor);
        Assert.assertEquals((Object)apiServiceDescriptor.getUrl().substring("unix://".length()), (Object)channel.authority());
        channel.shutdownNow();
    }
}

