/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn;

import org.apache.beam.sdk.fn.JvmInitializers;
import org.apache.beam.sdk.harness.JvmInitializer;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.TestPipeline;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class JvmInitializersTest {
    private static @UnknownKeyFor @NonNull @Initialized Boolean onStartupRan;
    private static @UnknownKeyFor @NonNull @Initialized Boolean beforeProcessingRan;
    private static @UnknownKeyFor @NonNull @Initialized PipelineOptions receivedOptions;

    @Before
    public void setUp() {
        onStartupRan = false;
        beforeProcessingRan = false;
        receivedOptions = null;
    }

    @Test
    public void runOnStartup_runsInitializers() {
        JvmInitializers.runOnStartup();
        Assert.assertTrue((boolean)onStartupRan);
    }

    @Test
    public void runBeforeProcessing_runsInitializersWithOptions() {
        PipelineOptions options = TestPipeline.testingPipelineOptions();
        JvmInitializers.runBeforeProcessing((PipelineOptions)options);
        Assert.assertTrue((boolean)beforeProcessingRan);
        Assert.assertEquals((Object)options, (Object)receivedOptions);
    }

    public static class TestInitializer
    implements JvmInitializer {
        public void onStartup() {
            onStartupRan = true;
        }

        public void beforeProcessing(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            beforeProcessingRan = true;
            receivedOptions = options;
        }
    }
}

