/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.windowing;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.fn.windowing.AutoValue_EncodedBoundedWindow;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.joda.time.Instant;

@AutoValue
public abstract class EncodedBoundedWindow
extends BoundedWindow {
    public static EncodedBoundedWindow forEncoding(ByteString encodedWindow) {
        return new AutoValue_EncodedBoundedWindow(encodedWindow);
    }

    public abstract ByteString getEncodedWindow();

    public Instant maxTimestamp() {
        throw new UnsupportedOperationException("TODO: Add support for reading the timestamp from the encoded window.");
    }

    public static class Coder
    extends AtomicCoder<EncodedBoundedWindow> {
        public static final Coder INSTANCE = new Coder();

        private Coder() {
        }

        public void encode(EncodedBoundedWindow value, OutputStream outStream) throws CoderException, IOException {
            VarInt.encode((int)value.getEncodedWindow().size(), (OutputStream)outStream);
            value.getEncodedWindow().writeTo(outStream);
        }

        public EncodedBoundedWindow decode(InputStream inStream) throws CoderException, IOException {
            int size = VarInt.decodeInt((InputStream)inStream);
            ByteString encodedWindow = ByteString.readFrom((InputStream)ByteStreams.limit((InputStream)inStream, (long)size));
            return EncodedBoundedWindow.forEncoding(encodedWindow);
        }

        public boolean consistentWithEquals() {
            return true;
        }

        public boolean isRegisterByteSizeObserverCheap(EncodedBoundedWindow value) {
            return true;
        }

        protected long getEncodedElementByteSize(EncodedBoundedWindow value) throws Exception {
            return (long)VarInt.getLength((int)value.getEncodedWindow().size()) + (long)value.getEncodedWindow().size();
        }
    }
}

