/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.splittabledofn;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.Sizes;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;

public class RestrictionTrackers {
    public static <RestrictionT, PositionT> RestrictionTracker<RestrictionT, PositionT> observe(RestrictionTracker<RestrictionT, PositionT> restrictionTracker, ClaimObserver<PositionT> claimObserver) {
        if (restrictionTracker instanceof Sizes.HasSize) {
            return new RestrictionTrackerObserverWithSize<RestrictionT, PositionT>(restrictionTracker, claimObserver);
        }
        return new RestrictionTrackerObserver<RestrictionT, PositionT>(restrictionTracker, claimObserver);
    }

    @ThreadSafe
    private static class RestrictionTrackerObserverWithSize<RestrictionT, PositionT>
    extends RestrictionTrackerObserver<RestrictionT, PositionT>
    implements Sizes.HasSize {
        protected RestrictionTrackerObserverWithSize(RestrictionTracker<RestrictionT, PositionT> delegate, ClaimObserver<PositionT> claimObserver) {
            super(delegate, claimObserver);
        }

        public synchronized double getSize() {
            return ((Sizes.HasSize)this.delegate).getSize();
        }
    }

    @ThreadSafe
    private static class RestrictionTrackerObserver<RestrictionT, PositionT>
    extends RestrictionTracker<RestrictionT, PositionT> {
        protected final RestrictionTracker<RestrictionT, PositionT> delegate;
        private final ClaimObserver<PositionT> claimObserver;

        protected RestrictionTrackerObserver(RestrictionTracker<RestrictionT, PositionT> delegate, ClaimObserver<PositionT> claimObserver) {
            this.delegate = delegate;
            this.claimObserver = claimObserver;
        }

        public synchronized boolean tryClaim(PositionT position) {
            if (this.delegate.tryClaim(position)) {
                this.claimObserver.onClaimed(position);
                return true;
            }
            this.claimObserver.onClaimFailed(position);
            return false;
        }

        public synchronized RestrictionT currentRestriction() {
            return (RestrictionT)this.delegate.currentRestriction();
        }

        public synchronized SplitResult<RestrictionT> trySplit(double fractionOfRemainder) {
            return this.delegate.trySplit(fractionOfRemainder);
        }

        public synchronized void checkDone() throws IllegalStateException {
            this.delegate.checkDone();
        }
    }

    public static interface ClaimObserver<PositionT> {
        public void onClaimed(PositionT var1);

        public void onClaimFailed(PositionT var1);
    }
}

