/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.zetasketch;

import com.google.protos.zetasketch.Aggregator;
import com.google.zetasketch.HyperLogLogPlusPlus;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.extensions.zetasketch.HyperLogLogPlusPlusCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HllCountMergePartialFn<@UnknownKeyFor HllT>
extends Combine.CombineFn<byte[], HyperLogLogPlusPlus<HllT>, byte[]> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HllCountMergePartialFn.class);

    private HllCountMergePartialFn() {
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized HllCountMergePartialFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> create() {
        return new HllCountMergePartialFn();
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@Nullable @UnknownKeyFor @Initialized HyperLogLogPlusPlus<HllT>> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized []> inputCoder) {
        return NullableCoder.of(HyperLogLogPlusPlusCoder.of());
    }

    public @Nullable @UnknownKeyFor @Initialized HyperLogLogPlusPlus<HllT> createAccumulator() {
        return null;
    }

    public @Nullable @UnknownKeyFor @Initialized HyperLogLogPlusPlus<HllT> addInput(@Nullable @UnknownKeyFor @Initialized HyperLogLogPlusPlus<HllT> accumulator, @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] input) {
        if (input == null) {
            LOG.warn("Received a null and treated it as an empty sketch. Consider replacing nulls with empty byte arrays (byte[0]) in upstream transforms for better space-efficiency and safety.");
            return accumulator;
        }
        if (input.length == 0) {
            return accumulator;
        }
        if (accumulator == null) {
            HyperLogLogPlusPlus result = HyperLogLogPlusPlus.forProto((byte[])input);
            return result;
        }
        accumulator.merge(input);
        return accumulator;
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public @Nullable @UnknownKeyFor @Initialized HyperLogLogPlusPlus<HllT> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@Nullable @UnknownKeyFor @Initialized HyperLogLogPlusPlus<HllT>> accumulators) {
        HyperLogLogPlusPlus merged = this.createAccumulator();
        for (HyperLogLogPlusPlus<HllT> accumulator : accumulators) {
            if (accumulator == null) continue;
            if (merged == null) {
                HyperLogLogPlusPlus clonedAccumulator;
                merged = clonedAccumulator = HyperLogLogPlusPlus.forProto((Aggregator.AggregatorStateProto)accumulator.serializeToProto());
                continue;
            }
            merged.merge(accumulator);
        }
        return merged;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] extractOutput(@Nullable @UnknownKeyFor @Initialized HyperLogLogPlusPlus<HllT> accumulator) {
        if (accumulator == null) {
            return new byte[0];
        }
        return accumulator.serializeToByteArray();
    }
}

