/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.zetasketch;

import com.google.zetasketch.HyperLogLogPlusPlus;
import java.nio.ByteBuffer;
import org.apache.beam.sdk.extensions.zetasketch.HllCountInitFn;
import org.apache.beam.sdk.extensions.zetasketch.HllCountMergePartialFn;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HllCount {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HllCount.class);
    public static final @UnknownKeyFor @NonNull @Initialized int MINIMUM_PRECISION = 10;
    public static final @UnknownKeyFor @NonNull @Initialized int MAXIMUM_PRECISION = 24;
    public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_PRECISION = 15;

    private HllCount() {
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getSketchFromByteBuffer(@Nullable @UnknownKeyFor @Initialized ByteBuffer bf) {
        if (bf == null) {
            return new byte[0];
        }
        byte[] result = new byte[bf.remaining()];
        bf.get(result);
        return result;
    }

    public static final class Extract {
        private Extract() {
        }

        public static @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Long>> globally() {
            return new Globally();
        }

        public static <K> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>>> perKey() {
            return new PerKey();
        }

        private static final class PerKey<@UnknownKeyFor K>
        extends PTransform<PCollection<KV<K, byte[]>>, PCollection<KV<K, Long>>> {
            private PerKey() {
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> input) {
                return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<K, byte[]>, KV<K, Long>>(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> kv, // Could not load outer class - annotation placement on inner may be incorrect
                    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>> receiver) {
                        byte[] sketch = (byte[])kv.getValue();
                        if (sketch == null) {
                            LOG.warn("Received a null and treated it as an empty sketch. Consider replacing nulls with empty byte arrays (byte[0]) in upstream transforms for better space-efficiency and safety.");
                            receiver.output((Object)KV.of((Object)kv.getKey(), (Object)0L));
                        } else if (sketch.length == 0) {
                            receiver.output((Object)KV.of((Object)kv.getKey(), (Object)0L));
                        } else {
                            receiver.output((Object)KV.of((Object)kv.getKey(), (Object)HyperLogLogPlusPlus.forProto((byte[])sketch).result()));
                        }
                    }
                }));
            }
        }

        private static final class Globally
        extends PTransform<PCollection<byte[]>, PCollection<Long>> {
            private Globally() {
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Long> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> input) {
                return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<byte[], Long>(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] sketch, // Could not load outer class - annotation placement on inner may be incorrect
                    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Long> receiver) {
                        if (sketch == null) {
                            LOG.warn("Received a null and treated it as an empty sketch. Consider replacing nulls with empty byte arrays (byte[0]) in upstream transforms for better space-efficiency and safety.");
                            receiver.output((Object)0L);
                        } else if (sketch.length == 0) {
                            receiver.output((Object)0L);
                        } else {
                            receiver.output((Object)HyperLogLogPlusPlus.forProto((byte[])sketch).result());
                        }
                    }
                }));
            }
        }
    }

    public static final class MergePartial {
        private MergePartial() {
        }

        public static // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.Globally<@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> globally() {
            return Combine.globally(HllCountMergePartialFn.create());
        }

        public static <K> // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> perKey() {
            return Combine.perKey(HllCountMergePartialFn.create());
        }
    }

    public static final class Init {
        private Init() {
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder<@UnknownKeyFor @NonNull @Initialized Integer> forIntegers() {
            return new Builder<Integer>(HllCountInitFn.forInteger());
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder<@UnknownKeyFor @NonNull @Initialized Long> forLongs() {
            return new Builder<Long>(HllCountInitFn.forLong());
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder<@UnknownKeyFor @NonNull @Initialized String> forStrings() {
            return new Builder<String>(HllCountInitFn.forString());
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> forBytes() {
            return new Builder<byte[]>(HllCountInitFn.forBytes());
        }

        public static final class Builder<@UnknownKeyFor InputT> {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized HllCountInitFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> initFn;

            private Builder(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized HllCountInitFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> initFn) {
                this.initFn = initFn;
            }

            public @UnknownKeyFor @NonNull @Initialized Builder<InputT> withPrecision(@UnknownKeyFor @NonNull @Initialized int precision) {
                this.initFn.setPrecision(precision);
                return this;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Combine.Globally<InputT, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> globally() {
                return Combine.globally(this.initFn);
            }

            public <K> // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, InputT, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> perKey() {
                return Combine.perKey(this.initFn);
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized HllCountInitFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> asUdaf() {
                return this.initFn;
            }
        }
    }
}

