/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.zetasketch;

import com.google.auto.value.AutoValue;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.extensions.zetasketch.AutoValue_ApproximateCountDistinct_Globally;
import org.apache.beam.sdk.extensions.zetasketch.AutoValue_ApproximateCountDistinct_PerKey;
import org.apache.beam.sdk.extensions.zetasketch.HllCount;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ApproximateCountDistinct {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> HLL_IMPLEMENTED_TYPES = ImmutableList.of((Object)TypeDescriptors.strings(), (Object)TypeDescriptors.longs(), (Object)TypeDescriptors.integers(), (Object)new TypeDescriptor<byte[]>(){});

    public static <T> @UnknownKeyFor @NonNull @Initialized Globally<T> globally() {
        return new AutoValue_ApproximateCountDistinct_Globally.Builder().setPrecision(15).build();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PerKey<K, V> perKey() {
        return new AutoValue_ApproximateCountDistinct_PerKey.Builder().setPrecision(15).build();
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getUdaf(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> input) {
        return ApproximateCountDistinct.builderForType(input).asUdaf();
    }

    private static void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder, @UnknownKeyFor @NonNull @Initialized Integer precision) {
        builder.add(DisplayData.item((String)"precision", (Integer)precision).withLabel("Precision"));
    }

    protected static <T> @UnknownKeyFor @NonNull @Initialized HllCount.Init.Builder<T> builderForType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> input) {
        HllCount.Init.Builder<Object> builder = null;
        if (input.equals((Object)TypeDescriptors.strings())) {
            builder = HllCount.Init.forStrings();
        }
        if (input.equals((Object)TypeDescriptors.longs())) {
            builder = HllCount.Init.forLongs();
        }
        if (input.equals((Object)TypeDescriptors.integers())) {
            builder = HllCount.Init.forIntegers();
        }
        if (input.equals((Object)new TypeDescriptor<byte[]>(){})) {
            builder = HllCount.Init.forBytes();
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Type not supported %s", input));
        }
        HllCount.Init.Builder<Object> output = builder;
        return output;
    }

    @AutoValue
    public static abstract class PerKey<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Long>>> {
        public abstract @UnknownKeyFor @NonNull @Initialized Integer getPrecision();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Contextful<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Contextful.Fn<@UnknownKeyFor @NonNull @Initialized KV<K, V>, @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>>> getMapping();

        public abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> toBuilder();

        public <K2, V2> @UnknownKeyFor @NonNull @Initialized PerKey<K2, V2> withPercision(@UnknownKeyFor @NonNull @Initialized Integer withPercision) {
            PerKey<K, V> perKey = this.toBuilder().setPrecision(withPercision).build();
            return perKey;
        }

        public @UnknownKeyFor @NonNull @Initialized PerKey<K, V> via(@UnknownKeyFor @NonNull @Initialized ProcessFunction<@UnknownKeyFor @NonNull @Initialized KV<K, V>, @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>> fn) {
            return this.toBuilder().setMapping(Contextful.fn(fn)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            Coder coder = ((KvCoder)input.getCoder()).getValueCoder();
            TypeDescriptor type = coder.getEncodedTypeDescriptor();
            if (HLL_IMPLEMENTED_TYPES.contains(type)) {
                HllCount.Init.Builder builder = ApproximateCountDistinct.builderForType(type);
                return (PCollection)((PCollection)input.apply(builder.perKey())).apply(HllCount.Extract.perKey());
            }
            Contextful<Contextful.Fn<KV<K, V>, KV<K, Long>>> mapping = this.getMapping();
            if (mapping != null) {
                Coder keyCoder = ((KvCoder)input.getCoder()).getKeyCoder();
                return (PCollection)((PCollection)((PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.kvs((TypeDescriptor)keyCoder.getEncodedTypeDescriptor(), (TypeDescriptor)TypeDescriptors.longs())).via(mapping))).apply(HllCount.Init.forLongs().perKey())).apply(HllCount.Extract.perKey());
            }
            throw new IllegalArgumentException(String.format("%s supports Integer, Long, String and byte[] objects directly not for %s type, you must provide a Mapping use via.", ((Object)((Object)this)).getClass().getCanonicalName(), type.toString()));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            ApproximateCountDistinct.populateDisplayData(builder, this.getPrecision());
        }

        @AutoValue.Builder
        public static abstract class Builder<@UnknownKeyFor K, @UnknownKeyFor V> {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setPrecision(@UnknownKeyFor @NonNull @Initialized Integer var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setMapping(@UnknownKeyFor @NonNull @Initialized Contextful<// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Contextful.Fn<@UnknownKeyFor @NonNull @Initialized KV<K, V>, @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>>> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized PerKey<K, V> build();
        }
    }

    @AutoValue
    public static abstract class Globally<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Long>> {
        public abstract @UnknownKeyFor @NonNull @Initialized int getPrecision();

        public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Contextful<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Contextful.Fn<T, @UnknownKeyFor @NonNull @Initialized Long>> getMapping();

        public @UnknownKeyFor @NonNull @Initialized Globally<T> via(@UnknownKeyFor @NonNull @Initialized ProcessFunction<T, @UnknownKeyFor @NonNull @Initialized Long> fn) {
            return this.toBuilder().setMapping(Contextful.fn(fn)).build();
        }

        public <V> @UnknownKeyFor @NonNull @Initialized Globally<V> withPercision(@UnknownKeyFor @NonNull @Initialized Integer withPercision) {
            Globally<T> globally = this.toBuilder().setPrecision(withPercision).build();
            return globally;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Long> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            TypeDescriptor type = input.getCoder().getEncodedTypeDescriptor();
            if (HLL_IMPLEMENTED_TYPES.contains(type)) {
                HllCount.Init.Builder builder = ApproximateCountDistinct.builderForType(type);
                return (PCollection)((PCollection)input.apply(builder.globally())).apply(HllCount.Extract.globally());
            }
            Contextful<Contextful.Fn<T, Long>> mapping = this.getMapping();
            if (mapping != null) {
                return (PCollection)((PCollection)((PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.longs()).via(mapping))).apply(HllCount.Init.forLongs().globally())).apply(HllCount.Extract.globally());
            }
            throw new IllegalArgumentException(String.format("%s supports Integer, Long, String and byte[] objects directly. For other types you must provide a Mapping function.", ((Object)((Object)this)).getClass().getCanonicalName()));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            ApproximateCountDistinct.populateDisplayData(builder, this.getPrecision());
        }

        @AutoValue.Builder
        public static abstract class Builder<@UnknownKeyFor T> {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPrecision(@UnknownKeyFor @NonNull @Initialized int var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMapping(@UnknownKeyFor @NonNull @Initialized Contextful<// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Contextful.Fn<T, @UnknownKeyFor @NonNull @Initialized Long>> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Globally<T> build();
        }
    }
}

