/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.zetasketch;

import com.google.zetasketch.HyperLogLogPlusPlus;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.zetasketch.ApproximateCountDistinct;
import org.apache.beam.sdk.extensions.zetasketch.HllCount;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class ApproximateCountDistinctTest {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    private static final List<Integer> INTS1 = Arrays.asList(1, 2, 3, 3, 1, 4);
    private static final Long INTS1_ESTIMATE;
    private static final int TEST_PRECISION = 20;

    @Test
    public void testIntegerBuilder() {
        PCollection ints = (PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]));
        HllCount.Init.Builder builder = ApproximateCountDistinct.builderForType((TypeDescriptor)ints.getCoder().getEncodedTypeDescriptor());
        PCollection result = (PCollection)((PCollection)ints.apply((PTransform)builder.globally())).apply(HllCount.Extract.globally());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Long[]{1L});
        this.p.run();
    }

    @Test
    public void testStringBuilder() {
        PCollection strings = (PCollection)this.p.apply((PTransform)Create.of((Object)"43", (Object[])new String[0]));
        HllCount.Init.Builder builder = ApproximateCountDistinct.builderForType((TypeDescriptor)strings.getCoder().getEncodedTypeDescriptor());
        PCollection result = (PCollection)((PCollection)strings.apply((PTransform)builder.globally())).apply(HllCount.Extract.globally());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Long[]{1L});
        this.p.run();
    }

    @Test
    public void testLongBuilder() {
        PCollection longs = (PCollection)this.p.apply((PTransform)Create.of((Object)1L, (Object[])new Long[0]));
        HllCount.Init.Builder builder = ApproximateCountDistinct.builderForType((TypeDescriptor)longs.getCoder().getEncodedTypeDescriptor());
        PCollection result = (PCollection)((PCollection)longs.apply((PTransform)builder.globally())).apply(HllCount.Extract.globally());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Long[]{1L});
        this.p.run();
    }

    @Test
    public void testBytesBuilder() {
        byte[] byteArray = new byte[]{65};
        PCollection bytes = (PCollection)this.p.apply((PTransform)Create.of((Object)byteArray, (Object[])new byte[0][]));
        TypeDescriptor a = bytes.getCoder().getEncodedTypeDescriptor();
        HllCount.Init.Builder builder = ApproximateCountDistinct.builderForType((TypeDescriptor)bytes.getCoder().getEncodedTypeDescriptor());
        PCollection result = (PCollection)((PCollection)bytes.apply((PTransform)builder.globally())).apply(HllCount.Extract.globally());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Long[]{1L});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testStandardTypesGlobalForInteger() {
        PCollection approxResultInteger = (PCollection)((PCollection)this.p.apply("Int", (PTransform)Create.of(INTS1))).apply("IntHLL", (PTransform)ApproximateCountDistinct.globally());
        PAssert.thatSingleton((PCollection)approxResultInteger).isEqualTo((Object)INTS1_ESTIMATE);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testStandardTypesGlobalForLong() {
        PCollection approxResultLong = (PCollection)((PCollection)this.p.apply("Long", (PTransform)Create.of((Iterable)INTS1.stream().map(Long::valueOf).collect(Collectors.toList())))).apply("LongHLL", (PTransform)ApproximateCountDistinct.globally());
        PAssert.thatSingleton((PCollection)approxResultLong).isEqualTo((Object)INTS1_ESTIMATE);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testStandardTypesGlobalForStrings() {
        PCollection approxResultString = (PCollection)((PCollection)this.p.apply("Str", (PTransform)Create.of((Iterable)INTS1.stream().map(String::valueOf).collect(Collectors.toList())))).apply("StrHLL", (PTransform)ApproximateCountDistinct.globally());
        PAssert.thatSingleton((PCollection)approxResultString).isEqualTo((Object)INTS1_ESTIMATE);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testStandardTypesGlobalForBytes() {
        PCollection approxResultByte = (PCollection)((PCollection)this.p.apply("BytesHLL", (PTransform)Create.of((Iterable)INTS1.stream().map(x -> ByteBuffer.allocate(4).putInt((int)x).array()).collect(Collectors.toList())))).apply((PTransform)ApproximateCountDistinct.globally());
        PAssert.thatSingleton((PCollection)approxResultByte).isEqualTo((Object)INTS1_ESTIMATE);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testStandardTypesPerKeyForInteger() {
        ArrayList<KV> ints = new ArrayList<KV>();
        for (int i = 0; i < 3; ++i) {
            for (int k : INTS1) {
                ints.add(KV.of((Object)i, (Object)k));
            }
        }
        PCollection result = (PCollection)((PCollection)this.p.apply("Int", (PTransform)Create.of(ints))).apply("IntHLL", (PTransform)ApproximateCountDistinct.perKey());
        PAssert.that((PCollection)result).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)0, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)1, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)2, (Object)INTS1_ESTIMATE)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testStandardTypesPerKeyForLong() {
        ArrayList<KV> longs = new ArrayList<KV>();
        for (int i = 0; i < 3; ++i) {
            for (int k : INTS1) {
                longs.add(KV.of((Object)i, (Object)k));
            }
        }
        PCollection result = (PCollection)((PCollection)this.p.apply("Long", (PTransform)Create.of(longs))).apply("LongHLL", (PTransform)ApproximateCountDistinct.perKey());
        PAssert.that((PCollection)result).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)0, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)1, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)2, (Object)INTS1_ESTIMATE)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testStandardTypesPerKeyForStrings() {
        ArrayList<KV> strings = new ArrayList<KV>();
        for (int i = 0; i < 3; ++i) {
            for (int k : INTS1) {
                strings.add(KV.of((Object)i, (Object)String.valueOf(k)));
            }
        }
        PCollection result = (PCollection)((PCollection)this.p.apply("Str", (PTransform)Create.of(strings))).apply("StrHLL", (PTransform)ApproximateCountDistinct.perKey());
        PAssert.that((PCollection)result).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)0, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)1, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)2, (Object)INTS1_ESTIMATE)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testStandardTypesPerKeyForBytes() {
        ArrayList<KV> bytes = new ArrayList<KV>();
        for (int i = 0; i < 3; ++i) {
            for (int k : INTS1) {
                bytes.add(KV.of((Object)i, (Object)ByteBuffer.allocate(4).putInt(k).array()));
            }
        }
        PCollection result = (PCollection)((PCollection)this.p.apply("BytesHLL", (PTransform)Create.of(bytes))).apply((PTransform)ApproximateCountDistinct.perKey());
        PAssert.that((PCollection)result).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)0, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)1, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)2, (Object)INTS1_ESTIMATE)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testObjectTypesGlobal() {
        PCollection approxResultInteger = (PCollection)((PCollection)this.p.apply("Int", (PTransform)Create.of((Iterable)INTS1.stream().map(x -> KV.of((Object)x, (Object)KV.of((Object)x, (Object)x))).collect(Collectors.toList())))).apply("IntHLL", (PTransform)ApproximateCountDistinct.globally().via((ProcessFunction & Serializable)x -> ((KV)x.getValue()).hashCode()));
        PAssert.thatSingleton((PCollection)approxResultInteger).isEqualTo((Object)INTS1_ESTIMATE);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testObjectTypesPerKey() {
        ArrayList<KV> ints = new ArrayList<KV>();
        for (int i = 0; i < 3; ++i) {
            for (int k : INTS1) {
                ints.add(KV.of((Object)i, (Object)KV.of((Object)i, (Object)k)));
            }
        }
        PCollection approxResultInteger = (PCollection)((PCollection)this.p.apply("Int", (PTransform)Create.of(ints))).apply("IntHLL", (PTransform)ApproximateCountDistinct.perKey().via((ProcessFunction & Serializable)x -> KV.of((Object)((Integer)x.getKey()), (Object)x.hashCode())).withPercision(Integer.valueOf(20)));
        PAssert.that((PCollection)approxResultInteger).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)0, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)1, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)2, (Object)INTS1_ESTIMATE)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testGlobalPercision() {
        PCollection approxResultInteger = (PCollection)((PCollection)this.p.apply("Int", (PTransform)Create.of(INTS1))).apply("IntHLL", (PTransform)ApproximateCountDistinct.globally().withPercision(Integer.valueOf(20)));
        PAssert.thatSingleton((PCollection)approxResultInteger).isEqualTo((Object)INTS1_ESTIMATE);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testPerKeyPercision() {
        ArrayList<KV> ints = new ArrayList<KV>();
        for (int i = 0; i < 3; ++i) {
            for (int k : INTS1) {
                ints.add(KV.of((Object)i, (Object)k));
            }
        }
        PCollection approxResultInteger = (PCollection)((PCollection)this.p.apply("Int", (PTransform)Create.of(ints))).apply("IntHLL", (PTransform)ApproximateCountDistinct.perKey().withPercision(Integer.valueOf(20)));
        PAssert.that((PCollection)approxResultInteger).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)0, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)1, (Object)INTS1_ESTIMATE), (Object)KV.of((Object)2, (Object)INTS1_ESTIMATE)));
        this.p.run();
    }

    static {
        HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus.Builder().buildForIntegers();
        INTS1.forEach(arg_0 -> ((HyperLogLogPlusPlus)hll).add(arg_0));
        INTS1_ESTIMATE = hll.longResult();
    }
}

