/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.zetasketch;

import com.google.zetasketch.HyperLogLogPlusPlus;
import com.google.zetasketch.shaded.com.google.protobuf.ByteString;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.extensions.zetasketch.HyperLogLogPlusPlusCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

abstract class HllCountInitFn<@UnknownKeyFor InputT, @UnknownKeyFor HllT>
extends Combine.CombineFn<InputT, HyperLogLogPlusPlus<HllT>, byte[]> {
    private @UnknownKeyFor @NonNull @Initialized int precision = 15;

    HllCountInitFn() {
    }

    @UnknownKeyFor @NonNull @Initialized int getPrecision() {
        return this.precision;
    }

    void setPrecision(@UnknownKeyFor @NonNull @Initialized int precision) {
        Preconditions.checkArgument((precision >= 10 && precision <= 24 ? 1 : 0) != 0, (String)"Invalid precision: %s. Valid range is [%s, %s].", (Object)precision, (Object)10, (Object)24);
        this.precision = precision;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] defaultValue() {
        return new byte[0];
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<HllT>> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) {
        return HyperLogLogPlusPlusCoder.of();
    }

    public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<HllT> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<HllT>> accumulators) {
        HyperLogLogPlusPlus merged = (HyperLogLogPlusPlus)this.createAccumulator();
        for (HyperLogLogPlusPlus<HllT> accumulator : accumulators) {
            merged.merge(accumulator);
        }
        return merged;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] extractOutput(@UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<HllT> accumulator) {
        return accumulator.serializeToByteArray();
    }

    static @UnknownKeyFor @NonNull @Initialized HllCountInitFn<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Integer> forInteger() {
        return new ForInteger();
    }

    static @UnknownKeyFor @NonNull @Initialized HllCountInitFn<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> forLong() {
        return new ForLong();
    }

    static @UnknownKeyFor @NonNull @Initialized HllCountInitFn<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> forString() {
        return new ForString();
    }

    static @UnknownKeyFor @NonNull @Initialized HllCountInitFn<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized ByteString> forBytes() {
        return new ForBytes();
    }

    private static class ForBytes
    extends HllCountInitFn<byte[], ByteString> {
        private ForBytes() {
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized ByteString> createAccumulator() {
            return new HyperLogLogPlusPlus.Builder().normalPrecision(this.getPrecision()).buildForBytes();
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized ByteString> addInput(@UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized ByteString> accumulator, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
            accumulator.add(input);
            return accumulator;
        }
    }

    private static class ForString
    extends HllCountInitFn<String, String> {
        private ForString() {
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized String> createAccumulator() {
            return new HyperLogLogPlusPlus.Builder().normalPrecision(this.getPrecision()).buildForStrings();
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized String> addInput(@UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized String> accumulator, @UnknownKeyFor @NonNull @Initialized String input) {
            accumulator.add((Object)input);
            return accumulator;
        }
    }

    private static class ForLong
    extends HllCountInitFn<Long, Long> {
        private ForLong() {
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized Long> createAccumulator() {
            return new HyperLogLogPlusPlus.Builder().normalPrecision(this.getPrecision()).buildForLongs();
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized Long> addInput(@UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized Long> accumulator, @UnknownKeyFor @NonNull @Initialized Long input) {
            accumulator.add(input.longValue());
            return accumulator;
        }
    }

    private static class ForInteger
    extends HllCountInitFn<Integer, Integer> {
        private ForInteger() {
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized Integer> createAccumulator() {
            return new HyperLogLogPlusPlus.Builder().normalPrecision(this.getPrecision()).buildForIntegers();
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized Integer> addInput(@UnknownKeyFor @NonNull @Initialized HyperLogLogPlusPlus<@UnknownKeyFor @NonNull @Initialized Integer> accumulator, @UnknownKeyFor @NonNull @Initialized Integer input) {
            accumulator.add(input.intValue());
            return accumulator;
        }
    }
}

