/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.zetasketch;

import com.google.zetasketch.HyperLogLogPlusPlus;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.zetasketch.HllCount;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HllCountTest {
    @Rule
    public final transient @UnknownKeyFor @NonNull @Initialized TestPipeline p = TestPipeline.create();
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] EMPTY_SKETCH = new byte[0];
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> INTS1 = Arrays.asList(1, 2, 3, 3, 1, 4);
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] INTS1_SKETCH;
    private static final @UnknownKeyFor @NonNull @Initialized Long INTS1_ESTIMATE;
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> INTS2;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] INTS2_SKETCH;
    private static final @UnknownKeyFor @NonNull @Initialized Long INTS2_ESTIMATE;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] INTS1_INTS2_SKETCH;
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Long> LONGS;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] LONGS_SKETCH;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] LONGS_SKETCH_OF_EMPTY_SET;
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> STRINGS;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] STRINGS_SKETCH;
    private static final @UnknownKeyFor @NonNull @Initialized int TEST_PRECISION = 20;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] STRINGS_SKETCH_TEST_PRECISION;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] BYTES0;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] BYTES1;
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> BYTES;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] BYTES_SKETCH;

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForIntegersGlobally() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(INTS1))).apply((PTransform)HllCount.Init.forIntegers().globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)INTS1_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForLongsGlobally() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(LONGS))).apply((PTransform)HllCount.Init.forLongs().globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)LONGS_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForLongsGloballyForEmptyInput() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.empty((TypeDescriptor)TypeDescriptor.of(Long.class)))).apply((PTransform)HllCount.Init.forLongs().globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)EMPTY_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForStringsGlobally() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(STRINGS))).apply((PTransform)HllCount.Init.forStrings().globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)STRINGS_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForStringsGloballyWithPrecision() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(STRINGS))).apply((PTransform)HllCount.Init.forStrings().withPrecision(20).globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)STRINGS_SKETCH_TEST_PRECISION);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForStringsGloballyWithInvalidPrecision() {
        this.thrown.expect(IllegalArgumentException.class);
        ((PCollection)this.p.apply((PTransform)Create.of(STRINGS))).apply((PTransform)HllCount.Init.forStrings().withPrecision(0).globally());
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForBytesGlobally() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(BYTES))).apply((PTransform)HllCount.Init.forBytes().globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)BYTES_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForIntegersPerKey() {
        ArrayList input = new ArrayList();
        INTS1.forEach(i -> input.add(KV.of((Object)"k1", (Object)i)));
        INTS1.forEach(i -> input.add(KV.of((Object)"k2", (Object)i)));
        INTS2.forEach(i -> input.add(KV.of((Object)"k1", (Object)i)));
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(input))).apply((PTransform)HllCount.Init.forIntegers().perKey());
        PAssert.that((PCollection)result).containsInAnyOrder(Arrays.asList(KV.of((Object)"k1", (Object)INTS1_INTS2_SKETCH), KV.of((Object)"k2", (Object)INTS1_SKETCH)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForLongsPerKey() {
        ArrayList input = new ArrayList();
        LONGS.forEach(l -> input.add(KV.of((Object)"k", (Object)l)));
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(input))).apply((PTransform)HllCount.Init.forLongs().perKey());
        PAssert.that((PCollection)result).containsInAnyOrder(Collections.singletonList(KV.of((Object)"k", (Object)LONGS_SKETCH)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForStringsPerKey() {
        ArrayList input = new ArrayList();
        STRINGS.forEach(s -> input.add(KV.of((Object)"k", (Object)s)));
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(input))).apply((PTransform)HllCount.Init.forStrings().perKey());
        PAssert.that((PCollection)result).containsInAnyOrder(Collections.singletonList(KV.of((Object)"k", (Object)STRINGS_SKETCH)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForStringsPerKeyWithPrecision() {
        ArrayList input = new ArrayList();
        STRINGS.forEach(s -> input.add(KV.of((Object)"k", (Object)s)));
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(input))).apply((PTransform)HllCount.Init.forStrings().withPrecision(20).perKey());
        PAssert.that((PCollection)result).containsInAnyOrder(Collections.singletonList(KV.of((Object)"k", (Object)STRINGS_SKETCH_TEST_PRECISION)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForStringsPerKeyWithInvalidPrecision() {
        ArrayList input = new ArrayList();
        STRINGS.forEach(s -> input.add(KV.of((Object)"k", (Object)s)));
        this.thrown.expect(IllegalArgumentException.class);
        ((PCollection)this.p.apply((PTransform)Create.of(input))).apply((PTransform)HllCount.Init.forStrings().withPrecision(0).perKey());
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testInitForBytesPerKey() {
        ArrayList input = new ArrayList();
        BYTES.forEach(bs -> input.add(KV.of((Object)"k", (Object)bs)));
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(input))).apply((PTransform)HllCount.Init.forBytes().perKey());
        PAssert.that((PCollection)result).containsInAnyOrder(Collections.singletonList(KV.of((Object)"k", (Object)BYTES_SKETCH)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialGlobally() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)INTS1_SKETCH, (Object[])new byte[][]{INTS2_SKETCH}))).apply((PTransform)HllCount.MergePartial.globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)INTS1_INTS2_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialGloballyForEmptyInput() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.empty((TypeDescriptor)TypeDescriptor.of(byte[].class)))).apply((PTransform)HllCount.MergePartial.globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)EMPTY_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialGloballyForSingletonInput() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)LONGS_SKETCH, (Object[])new byte[0][]))).apply((PTransform)HllCount.MergePartial.globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)LONGS_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialGloballyForSingletonInputEmptySketch() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)EMPTY_SKETCH, (Object[])new byte[0][]))).apply((PTransform)HllCount.MergePartial.globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)EMPTY_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialGloballyForMergeWithEmptySketch() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)LONGS_SKETCH, (Object[])new byte[][]{EMPTY_SKETCH}))).apply((PTransform)HllCount.MergePartial.globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)LONGS_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialGloballyForMergeMultipleEmptySketches() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)EMPTY_SKETCH, (Object[])new byte[][]{EMPTY_SKETCH}))).apply((PTransform)HllCount.MergePartial.globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)EMPTY_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialGloballyForMergeWithSketchOfEmptySet() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)LONGS_SKETCH, (Object[])new byte[][]{LONGS_SKETCH_OF_EMPTY_SET}))).apply((PTransform)HllCount.MergePartial.globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)LONGS_SKETCH);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialGloballyForMergeEmptySketchWithSketchOfEmptySet() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)EMPTY_SKETCH, (Object[])new byte[][]{LONGS_SKETCH_OF_EMPTY_SET}))).apply((PTransform)HllCount.MergePartial.globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)LONGS_SKETCH_OF_EMPTY_SET);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialGloballyForIncompatibleSketches() {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)INTS1_SKETCH, (Object[])new byte[][]{STRINGS_SKETCH}))).apply((PTransform)HllCount.MergePartial.globally());
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialPerKey() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)KV.of((Object)"k1", (Object)INTS1_SKETCH), (Object[])new KV[]{KV.of((Object)"k2", (Object)STRINGS_SKETCH), KV.of((Object)"k1", (Object)INTS2_SKETCH)}))).apply((PTransform)HllCount.MergePartial.perKey());
        PAssert.that((PCollection)result).containsInAnyOrder(Arrays.asList(KV.of((Object)"k1", (Object)INTS1_INTS2_SKETCH), KV.of((Object)"k2", (Object)STRINGS_SKETCH)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialPerKeyForMergeWithEmptySketch() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)KV.of((Object)"k1", (Object)INTS1_SKETCH), (Object[])new KV[]{KV.of((Object)"k2", (Object)EMPTY_SKETCH), KV.of((Object)"k1", (Object)EMPTY_SKETCH)}))).apply((PTransform)HllCount.MergePartial.perKey());
        PAssert.that((PCollection)result).containsInAnyOrder(Arrays.asList(KV.of((Object)"k1", (Object)INTS1_SKETCH), KV.of((Object)"k2", (Object)EMPTY_SKETCH)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialPerKeyForMergeMultipleEmptySketches() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)KV.of((Object)"k1", (Object)EMPTY_SKETCH), (Object[])new KV[]{KV.of((Object)"k2", (Object)STRINGS_SKETCH), KV.of((Object)"k1", (Object)EMPTY_SKETCH)}))).apply((PTransform)HllCount.MergePartial.perKey());
        PAssert.that((PCollection)result).containsInAnyOrder(Arrays.asList(KV.of((Object)"k1", (Object)EMPTY_SKETCH), KV.of((Object)"k2", (Object)STRINGS_SKETCH)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMergePartialPerKeyForIncompatibleSketches() {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)KV.of((Object)"k1", (Object)LONGS_SKETCH), (Object[])new KV[]{KV.of((Object)"k2", (Object)STRINGS_SKETCH), KV.of((Object)"k1", (Object)BYTES_SKETCH)}))).apply((PTransform)HllCount.MergePartial.perKey());
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testExtractGlobally() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)INTS1_SKETCH, (Object[])new byte[][]{INTS2_SKETCH}))).apply(HllCount.Extract.globally());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Long[]{INTS1_ESTIMATE, INTS2_ESTIMATE});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testExtractGloballyForEmptySketch() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)EMPTY_SKETCH, (Object[])new byte[0][]))).apply(HllCount.Extract.globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)0L);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testExtractGloballyForSketchOfEmptySet() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)LONGS_SKETCH_OF_EMPTY_SET, (Object[])new byte[0][]))).apply(HllCount.Extract.globally());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)0L);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testExtractPerKey() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)KV.of((Object)"k", (Object)INTS1_SKETCH), (Object[])new KV[]{KV.of((Object)"k", (Object)INTS2_SKETCH)}))).apply(HllCount.Extract.perKey());
        PAssert.that((PCollection)result).containsInAnyOrder(Arrays.asList(KV.of((Object)"k", (Object)INTS1_ESTIMATE), KV.of((Object)"k", (Object)INTS2_ESTIMATE)));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testExtractPerKeyForEmptySketch() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)KV.of((Object)"k", (Object)EMPTY_SKETCH), (Object[])new KV[0]))).apply(HllCount.Extract.perKey());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)KV.of((Object)"k", (Object)0L));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testExtractPerKeyForSketchOfEmptySet() {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)KV.of((Object)"k", (Object)LONGS_SKETCH_OF_EMPTY_SET), (Object[])new KV[0]))).apply(HllCount.Extract.perKey());
        PAssert.thatSingleton((PCollection)result).isEqualTo((Object)KV.of((Object)"k", (Object)0L));
        this.p.run();
    }

    @Test
    public void testGetSketchFromByteBufferForEmptySketch() {
        Assert.assertArrayEquals((byte[])HllCount.getSketchFromByteBuffer(null), (byte[])EMPTY_SKETCH);
    }

    @Test
    public void testGetSketchFromByteBufferForNonEmptySketch() {
        ByteBuffer bf = ByteBuffer.wrap(INTS1_SKETCH);
        Assert.assertArrayEquals((byte[])HllCount.getSketchFromByteBuffer((ByteBuffer)bf), (byte[])INTS1_SKETCH);
    }

    static {
        HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus.Builder().buildForIntegers();
        INTS1.forEach(arg_0 -> ((HyperLogLogPlusPlus)hll).add(arg_0));
        INTS1_SKETCH = hll.serializeToByteArray();
        INTS1_ESTIMATE = hll.longResult();
        INTS2 = Arrays.asList(3, 3, 3, 3);
        hll = new HyperLogLogPlusPlus.Builder().buildForIntegers();
        INTS2.forEach(arg_0 -> ((HyperLogLogPlusPlus)hll).add(arg_0));
        INTS2_SKETCH = hll.serializeToByteArray();
        INTS2_ESTIMATE = hll.longResult();
        hll = HyperLogLogPlusPlus.forProto((byte[])INTS1_SKETCH);
        hll.merge(INTS2_SKETCH);
        INTS1_INTS2_SKETCH = hll.serializeToByteArray();
        LONGS = Collections.singletonList(1L);
        hll = new HyperLogLogPlusPlus.Builder().buildForLongs();
        LONGS.forEach(arg_0 -> ((HyperLogLogPlusPlus)hll).add(arg_0));
        LONGS_SKETCH = hll.serializeToByteArray();
        hll = new HyperLogLogPlusPlus.Builder().buildForLongs();
        LONGS_SKETCH_OF_EMPTY_SET = hll.serializeToByteArray();
        STRINGS = Arrays.asList("s1", "s2", "s1", "s2");
        hll = new HyperLogLogPlusPlus.Builder().buildForStrings();
        STRINGS.forEach(arg_0 -> ((HyperLogLogPlusPlus)hll).add(arg_0));
        STRINGS_SKETCH = hll.serializeToByteArray();
        hll = new HyperLogLogPlusPlus.Builder().normalPrecision(20).buildForStrings();
        STRINGS.forEach(arg_0 -> ((HyperLogLogPlusPlus)hll).add(arg_0));
        STRINGS_SKETCH_TEST_PRECISION = hll.serializeToByteArray();
        BYTES0 = new byte[]{1, 10};
        BYTES1 = new byte[]{15};
        BYTES = Arrays.asList(BYTES0, BYTES1);
        hll = new HyperLogLogPlusPlus.Builder().buildForBytes();
        BYTES.forEach(arg_0 -> ((HyperLogLogPlusPlus)hll).add(arg_0));
        BYTES_SKETCH = hll.serializeToByteArray();
    }
}

