/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.zetasketch;

import com.google.protos.zetasketch.Aggregator;
import com.google.zetasketch.HyperLogLogPlusPlus;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.extensions.zetasketch.HyperLogLogPlusPlusCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HllCountMergePartialFn<HllT>
extends Combine.CombineFn<byte[], HyperLogLogPlusPlus<HllT>, byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(HllCountMergePartialFn.class);

    private HllCountMergePartialFn() {
    }

    static HllCountMergePartialFn<?> create() {
        return new HllCountMergePartialFn();
    }

    public Coder<HyperLogLogPlusPlus<HllT>> getAccumulatorCoder(CoderRegistry registry, Coder<byte[]> inputCoder) {
        return NullableCoder.of(HyperLogLogPlusPlusCoder.of());
    }

    @Nullable
    public HyperLogLogPlusPlus<HllT> createAccumulator() {
        return null;
    }

    @Nullable
    public HyperLogLogPlusPlus<HllT> addInput(@Nullable HyperLogLogPlusPlus<HllT> accumulator, byte[] input) {
        if (input == null) {
            LOG.warn("Received a null and treated it as an empty sketch. Consider replacing nulls with empty byte arrays (byte[0]) in upstream transforms for better space-efficiency and safety.");
            return accumulator;
        }
        if (input.length == 0) {
            return accumulator;
        }
        if (accumulator == null) {
            HyperLogLogPlusPlus result = HyperLogLogPlusPlus.forProto((byte[])input);
            return result;
        }
        accumulator.merge(input);
        return accumulator;
    }

    @Nullable
    public HyperLogLogPlusPlus<HllT> mergeAccumulators(Iterable<HyperLogLogPlusPlus<HllT>> accumulators) {
        HyperLogLogPlusPlus merged = this.createAccumulator();
        for (HyperLogLogPlusPlus<HllT> accumulator : accumulators) {
            if (accumulator == null) continue;
            if (merged == null) {
                HyperLogLogPlusPlus clonedAccumulator;
                merged = clonedAccumulator = HyperLogLogPlusPlus.forProto((Aggregator.AggregatorStateProto)accumulator.serializeToProto());
                continue;
            }
            merged.merge(accumulator);
        }
        return merged;
    }

    public byte[] extractOutput(@Nullable HyperLogLogPlusPlus<HllT> accumulator) {
        if (accumulator == null) {
            return new byte[0];
        }
        return accumulator.serializeToByteArray();
    }
}

