/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.zetasketch;

import com.google.zetasketch.HyperLogLogPlusPlus;
import com.google.zetasketch.shaded.com.google.protobuf.ByteString;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.extensions.zetasketch.HyperLogLogPlusPlusCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

abstract class HllCountInitFn<InputT, HllT>
extends Combine.CombineFn<InputT, HyperLogLogPlusPlus<HllT>, byte[]> {
    private int precision = 15;

    HllCountInitFn() {
    }

    int getPrecision() {
        return this.precision;
    }

    void setPrecision(int precision) {
        Preconditions.checkArgument((precision >= 10 && precision <= 24 ? 1 : 0) != 0, (String)"Invalid precision: %s. Valid range is [%s, %s].", (Object)precision, (Object)10, (Object)24);
        this.precision = precision;
    }

    public byte[] defaultValue() {
        return new byte[0];
    }

    public Coder<HyperLogLogPlusPlus<HllT>> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) {
        return HyperLogLogPlusPlusCoder.of();
    }

    public HyperLogLogPlusPlus<HllT> mergeAccumulators(Iterable<HyperLogLogPlusPlus<HllT>> accumulators) {
        HyperLogLogPlusPlus merged = (HyperLogLogPlusPlus)this.createAccumulator();
        for (HyperLogLogPlusPlus<HllT> accumulator : accumulators) {
            merged.merge(accumulator);
        }
        return merged;
    }

    public byte[] extractOutput(HyperLogLogPlusPlus<HllT> accumulator) {
        return accumulator.serializeToByteArray();
    }

    static HllCountInitFn<Integer, Integer> forInteger() {
        return new ForInteger();
    }

    static HllCountInitFn<Long, Long> forLong() {
        return new ForLong();
    }

    static HllCountInitFn<String, String> forString() {
        return new ForString();
    }

    static HllCountInitFn<byte[], ByteString> forBytes() {
        return new ForBytes();
    }

    private static class ForBytes
    extends HllCountInitFn<byte[], ByteString> {
        private ForBytes() {
        }

        public HyperLogLogPlusPlus<ByteString> createAccumulator() {
            return new HyperLogLogPlusPlus.Builder().normalPrecision(this.getPrecision()).buildForBytes();
        }

        public HyperLogLogPlusPlus<ByteString> addInput(HyperLogLogPlusPlus<ByteString> accumulator, byte[] input) {
            accumulator.add(input);
            return accumulator;
        }
    }

    private static class ForString
    extends HllCountInitFn<String, String> {
        private ForString() {
        }

        public HyperLogLogPlusPlus<String> createAccumulator() {
            return new HyperLogLogPlusPlus.Builder().normalPrecision(this.getPrecision()).buildForStrings();
        }

        public HyperLogLogPlusPlus<String> addInput(HyperLogLogPlusPlus<String> accumulator, String input) {
            accumulator.add((Object)input);
            return accumulator;
        }
    }

    private static class ForLong
    extends HllCountInitFn<Long, Long> {
        private ForLong() {
        }

        public HyperLogLogPlusPlus<Long> createAccumulator() {
            return new HyperLogLogPlusPlus.Builder().normalPrecision(this.getPrecision()).buildForLongs();
        }

        public HyperLogLogPlusPlus<Long> addInput(HyperLogLogPlusPlus<Long> accumulator, Long input) {
            accumulator.add(input.longValue());
            return accumulator;
        }
    }

    private static class ForInteger
    extends HllCountInitFn<Integer, Integer> {
        private ForInteger() {
        }

        public HyperLogLogPlusPlus<Integer> createAccumulator() {
            return new HyperLogLogPlusPlus.Builder().normalPrecision(this.getPrecision()).buildForIntegers();
        }

        public HyperLogLogPlusPlus<Integer> addInput(HyperLogLogPlusPlus<Integer> accumulator, Integer input) {
            accumulator.add(input.intValue());
            return accumulator;
        }
    }
}

