/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.zetasketch;

import com.google.zetasketch.HyperLogLogPlusPlus;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.zetasketch.HllCountInitFn;
import org.apache.beam.sdk.extensions.zetasketch.HllCountMergePartialFn;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public final class HllCount {
    private static final Logger LOG = LoggerFactory.getLogger(HllCount.class);
    public static final int MINIMUM_PRECISION = 10;
    public static final int MAXIMUM_PRECISION = 24;
    public static final int DEFAULT_PRECISION = 15;

    private HllCount() {
    }

    public static byte[] getSketchFromByteBuffer(@Nullable ByteBuffer bf) {
        if (bf == null) {
            return new byte[0];
        }
        byte[] result = new byte[bf.remaining()];
        bf.get(result);
        return result;
    }

    public static final class Extract {
        private Extract() {
        }

        public static PTransform<PCollection<byte[]>, PCollection<Long>> globally() {
            return new Globally();
        }

        public static <K> PTransform<PCollection<KV<K, byte[]>>, PCollection<KV<K, Long>>> perKey() {
            return new PerKey();
        }

        private static final class PerKey<K>
        extends PTransform<PCollection<KV<K, byte[]>>, PCollection<KV<K, Long>>> {
            private PerKey() {
            }

            public PCollection<KV<K, Long>> expand(PCollection<KV<K, byte[]>> input) {
                return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<K, byte[]>, KV<K, Long>>(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element KV<K, byte[]> kv, DoFn.OutputReceiver<KV<K, Long>> receiver) {
                        byte[] sketch = (byte[])kv.getValue();
                        if (sketch == null) {
                            LOG.warn("Received a null and treated it as an empty sketch. Consider replacing nulls with empty byte arrays (byte[0]) in upstream transforms for better space-efficiency and safety.");
                            receiver.output((Object)KV.of((Object)kv.getKey(), (Object)0L));
                        } else if (sketch.length == 0) {
                            receiver.output((Object)KV.of((Object)kv.getKey(), (Object)0L));
                        } else {
                            receiver.output((Object)KV.of((Object)kv.getKey(), (Object)HyperLogLogPlusPlus.forProto((byte[])sketch).result()));
                        }
                    }
                }));
            }
        }

        private static final class Globally
        extends PTransform<PCollection<byte[]>, PCollection<Long>> {
            private Globally() {
            }

            public PCollection<Long> expand(PCollection<byte[]> input) {
                return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<byte[], Long>(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element byte[] sketch, DoFn.OutputReceiver<Long> receiver) {
                        if (sketch == null) {
                            LOG.warn("Received a null and treated it as an empty sketch. Consider replacing nulls with empty byte arrays (byte[0]) in upstream transforms for better space-efficiency and safety.");
                            receiver.output((Object)0L);
                        } else if (sketch.length == 0) {
                            receiver.output((Object)0L);
                        } else {
                            receiver.output((Object)HyperLogLogPlusPlus.forProto((byte[])sketch).result());
                        }
                    }
                }));
            }
        }
    }

    public static final class MergePartial {
        private MergePartial() {
        }

        public static Combine.Globally<byte[], byte[]> globally() {
            return Combine.globally(HllCountMergePartialFn.create());
        }

        public static <K> Combine.PerKey<K, byte[], byte[]> perKey() {
            return Combine.perKey(HllCountMergePartialFn.create());
        }
    }

    public static final class Init {
        private Init() {
        }

        public static Builder<Integer> forIntegers() {
            return new Builder<Integer>(HllCountInitFn.forInteger());
        }

        public static Builder<Long> forLongs() {
            return new Builder<Long>(HllCountInitFn.forLong());
        }

        public static Builder<String> forStrings() {
            return new Builder<String>(HllCountInitFn.forString());
        }

        public static Builder<byte[]> forBytes() {
            return new Builder<byte[]>(HllCountInitFn.forBytes());
        }

        public static final class Builder<InputT> {
            private final HllCountInitFn<InputT, ?> initFn;

            private Builder(HllCountInitFn<InputT, ?> initFn) {
                this.initFn = initFn;
            }

            public Builder<InputT> withPrecision(int precision) {
                this.initFn.setPrecision(precision);
                return this;
            }

            public Combine.Globally<InputT, byte[]> globally() {
                return Combine.globally(this.initFn);
            }

            public <K> Combine.PerKey<K, InputT, byte[]> perKey() {
                return Combine.perKey(this.initFn);
            }
        }
    }
}

