/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.timeseries;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.timeseries.AutoValue_FillGapsTest_Message;
import org.apache.beam.sdk.extensions.timeseries.FillGaps;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.UsesLoopingTimer;
import org.apache.beam.sdk.testing.UsesStatefulParDo;
import org.apache.beam.sdk.testing.UsesStrictTimerOrdering;
import org.apache.beam.sdk.testing.UsesTimersInParDo;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FillGapsTest {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testFillGaps() {
        ImmutableList values = ImmutableList.of(Message.ofTimestamped("key1", "value0<", Instant.ofEpochSecond((long)0L)), Message.ofTimestamped("key2", "value0", Instant.ofEpochSecond((long)0L)), Message.ofTimestamped("key1", "value1<", Instant.ofEpochSecond((long)1L)), Message.ofTimestamped("key1", "value1", Instant.ofEpochSecond((long)1L).plus((ReadableDuration)Duration.millis((long)1L))), Message.ofTimestamped("key2", "value1<", Instant.ofEpochSecond((long)1L)), Message.ofTimestamped("key2", "value1", Instant.ofEpochSecond((long)1L).plus((ReadableDuration)Duration.millis((long)1L))), Message.ofTimestamped("key1", "value3", Instant.ofEpochSecond((long)3L)), Message.ofTimestamped("key2", "value3", Instant.ofEpochSecond((long)3L)));
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.timestamped((Iterable)values));
        PCollection gapFilled = (PCollection)((PCollection)input.apply((PTransform)FillGaps.of((Duration)Duration.standardSeconds((long)1L), (String[])new String[]{"key"}).withStopTime(Instant.ofEpochSecond((long)5L)))).apply(Reify.timestamps());
        FixedWindows fixedWindows = FixedWindows.of((Duration)Duration.standardSeconds((long)1L));
        PAssert.that((PCollection)gapFilled).containsInAnyOrder(Iterables.concat((Iterable)values, (Iterable)ImmutableList.of((Object)TimestampedValue.of((Object)Message.of("key1", "value1", Instant.ofEpochSecond((long)1L).plus((ReadableDuration)Duration.millis((long)1L))), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)2L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key2", "value1", Instant.ofEpochSecond((long)1L).plus((ReadableDuration)Duration.millis((long)1L))), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)2L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key1", "value3", Instant.ofEpochSecond((long)3L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)4L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key2", "value3", Instant.ofEpochSecond((long)3L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)4L)).maxTimestamp()))));
        this.pipeline.run();
    }

    @Test
    public void testFillGapsKeepEarliest() {
        ImmutableList values = ImmutableList.of(Message.ofTimestamped("key1", "value0<", Instant.ofEpochSecond((long)0L)), Message.ofTimestamped("key2", "value0", Instant.ofEpochSecond((long)0L)), Message.ofTimestamped("key1", "value1<", Instant.ofEpochSecond((long)1L)), Message.ofTimestamped("key1", "value1", Instant.ofEpochSecond((long)1L).plus((ReadableDuration)Duration.millis((long)1L))), Message.ofTimestamped("key2", "value1<", Instant.ofEpochSecond((long)1L)), Message.ofTimestamped("key2", "value1", Instant.ofEpochSecond((long)1L).plus((ReadableDuration)Duration.millis((long)1L))), Message.ofTimestamped("key1", "value3", Instant.ofEpochSecond((long)3L)), Message.ofTimestamped("key2", "value3", Instant.ofEpochSecond((long)3L)));
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.timestamped((Iterable)values));
        PCollection gapFilled = (PCollection)((PCollection)input.apply((PTransform)FillGaps.of((Duration)Duration.standardSeconds((long)1L), (String[])new String[]{"key"}).withMergeFunction(FillGaps.keepEarliest()).withStopTime(Instant.ofEpochSecond((long)5L)))).apply(Reify.timestamps());
        FixedWindows fixedWindows = FixedWindows.of((Duration)Duration.standardSeconds((long)1L));
        PAssert.that((PCollection)gapFilled).containsInAnyOrder(Iterables.concat((Iterable)values, (Iterable)ImmutableList.of((Object)TimestampedValue.of((Object)Message.of("key1", "value1<", Instant.ofEpochSecond((long)1L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)2L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key2", "value1<", Instant.ofEpochSecond((long)1L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)2L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key1", "value3", Instant.ofEpochSecond((long)3L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)4L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key2", "value3", Instant.ofEpochSecond((long)3L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)4L)).maxTimestamp()))));
        this.pipeline.run();
    }

    @Test
    public void testFillGapsMaxDuration() {
        ImmutableList values = ImmutableList.of(Message.ofTimestamped("key1", "value0", Instant.ofEpochSecond((long)0L)), Message.ofTimestamped("key2", "value0", Instant.ofEpochSecond((long)0L)), Message.ofTimestamped("key1", "value1", Instant.ofEpochSecond((long)1L)), Message.ofTimestamped("key2", "value1", Instant.ofEpochSecond((long)1L)), Message.ofTimestamped("key1", "value3", Instant.ofEpochSecond((long)10L)), Message.ofTimestamped("key2", "value3", Instant.ofEpochSecond((long)10L)));
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.timestamped((Iterable)values));
        PCollection gapFilled = (PCollection)((PCollection)input.apply((PTransform)FillGaps.of((Duration)Duration.standardSeconds((long)1L), (String[])new String[]{"key"}).withMaxGapFillBuckets(Long.valueOf(4L)).withStopTime(Instant.ofEpochSecond((long)11L)))).apply(Reify.timestamps());
        FixedWindows fixedWindows = FixedWindows.of((Duration)Duration.standardSeconds((long)1L));
        PAssert.that((PCollection)gapFilled).containsInAnyOrder(Iterables.concat((Iterable)values, (Iterable)ImmutableList.of((Object)TimestampedValue.of((Object)Message.of("key1", "value1", Instant.ofEpochSecond((long)1L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)2L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key1", "value1", Instant.ofEpochSecond((long)1L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)3L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key1", "value1", Instant.ofEpochSecond((long)1L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)4L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key1", "value1", Instant.ofEpochSecond((long)1L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)5L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key2", "value1", Instant.ofEpochSecond((long)1L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)2L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key2", "value1", Instant.ofEpochSecond((long)1L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)3L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key2", "value1", Instant.ofEpochSecond((long)1L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)4L)).maxTimestamp()), (Object)TimestampedValue.of((Object)Message.of("key2", "value1", Instant.ofEpochSecond((long)1L)), (Instant)fixedWindows.assignWindow(Instant.ofEpochSecond((long)5L)).maxTimestamp()))));
        this.pipeline.run();
    }

    @Test
    public void testFillGapsPropagateFunction() {
        ImmutableList values = ImmutableList.of(Message.ofTimestamped("key1", "value0<", Instant.ofEpochSecond((long)0L)), Message.ofTimestamped("key2", "value0", Instant.ofEpochSecond((long)0L)), Message.ofTimestamped("key1", "value1<", Instant.ofEpochSecond((long)1L)), Message.ofTimestamped("key1", "value1", Instant.ofEpochSecond((long)1L).plus((ReadableDuration)Duration.millis((long)1L))), Message.ofTimestamped("key2", "value1<", Instant.ofEpochSecond((long)1L)), Message.ofTimestamped("key2", "value1", Instant.ofEpochSecond((long)1L).plus((ReadableDuration)Duration.millis((long)1L))), Message.ofTimestamped("key1", "value3", Instant.ofEpochSecond((long)3L)), Message.ofTimestamped("key2", "value3", Instant.ofEpochSecond((long)3L)));
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.timestamped((Iterable)values));
        PCollection gapFilled = (PCollection)((PCollection)input.apply((PTransform)FillGaps.of((Duration)Duration.standardSeconds((long)1L), (String[])new String[]{"key"}).withInterpolateFunction(Message::update).withStopTime(Instant.ofEpochSecond((long)5L)))).apply(Reify.timestamps());
        FixedWindows fixedWindows = FixedWindows.of((Duration)Duration.standardSeconds((long)1L));
        Instant bucketTwoMax = fixedWindows.assignWindow(Instant.ofEpochSecond((long)2L)).maxTimestamp();
        Instant bucketFourMax = fixedWindows.assignWindow(Instant.ofEpochSecond((long)4L)).maxTimestamp();
        PAssert.that((PCollection)gapFilled).containsInAnyOrder(Iterables.concat((Iterable)values, (Iterable)ImmutableList.of(Message.ofTimestamped("key1", "value1", bucketTwoMax), Message.ofTimestamped("key2", "value1", bucketTwoMax), Message.ofTimestamped("key1", "value3", bucketFourMax), Message.ofTimestamped("key2", "value3", bucketFourMax))));
        this.pipeline.run();
    }

    @Test
    @Category(value={UsesTimersInParDo.class, UsesLoopingTimer.class, UsesStatefulParDo.class, UsesStrictTimerOrdering.class})
    public void testFillGapsFuzz() {
        for (int i = 0; i < 6; ++i) {
            this.fuzzTest(10, 500, 25, 20L);
        }
    }

    public void fuzzTest(int numKeys, int numBuckets, int maxGapSizeToGenerate, long maxGapSize) {
        Pipeline p = Pipeline.create();
        ArrayList values = Lists.newArrayList();
        ArrayList expectedGaps = Lists.newArrayList();
        for (int i = 0; i < numKeys; ++i) {
            String key = "key" + i;
            this.generateFuzzTimerseries(key, numBuckets, maxGapSizeToGenerate, maxGapSize, values, expectedGaps);
        }
        PCollection input = (PCollection)p.apply((PTransform)Create.timestamped((Iterable)values));
        PCollection gapFilled = (PCollection)((PCollection)input.apply((PTransform)FillGaps.of((Duration)Duration.standardSeconds((long)1L), (String[])new String[]{"key"}).withInterpolateFunction(Message::update).withMaxGapFillBuckets(Long.valueOf(maxGapSize)).withStopTime(Instant.ofEpochSecond((long)numBuckets)))).apply(Reify.timestamps());
        PAssert.that((PCollection)gapFilled).containsInAnyOrder(Iterables.concat((Iterable)values, (Iterable)expectedGaps));
        p.run();
    }

    void generateFuzzTimerseries(String key, int numBuckets, int maxGapSizeToGenerate, long maxGapSize, List<TimestampedValue<Message>> values, List<TimestampedValue<Message>> expectedGaps) {
        Random random = new Random();
        String lastValue = null;
        int currentGapSize = 0;
        int bucket = 0;
        while (bucket < numBuckets) {
            if (lastValue != null && currentGapSize < maxGapSizeToGenerate && random.nextInt(10) == 0) {
                int gapSize = random.nextInt(maxGapSizeToGenerate) + 1;
                int lastGapBucket = Math.min(bucket + gapSize, numBuckets);
                while (bucket < lastGapBucket) {
                    if ((long)currentGapSize < maxGapSize) {
                        this.addBucketToTimeseries(key, lastValue, bucket, expectedGaps);
                    }
                    ++currentGapSize;
                    ++bucket;
                }
                continue;
            }
            lastValue = "bucket" + bucket;
            currentGapSize = 0;
            this.addBucketToTimeseries(key, lastValue, bucket, values);
            ++bucket;
        }
    }

    void addBucketToTimeseries(String key, String value, int bucket, List<TimestampedValue<Message>> list) {
        FixedWindows fixedWindows = FixedWindows.of((Duration)Duration.standardSeconds((long)1L));
        IntervalWindow currentBucket = fixedWindows.assignWindow(Instant.ofEpochSecond((long)bucket));
        TimestampedValue<Message> message = Message.ofTimestamped(key, value, currentBucket.maxTimestamp());
        list.add(message);
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    static abstract class Message {
        Message() {
        }

        abstract String getKey();

        abstract String getValue();

        abstract Instant getTimestamp();

        static Message update(FillGaps.InterpolateData<Message> interpolateData) {
            Message value = (Message)interpolateData.getValue().getValue();
            Instant nextWindowMax = interpolateData.getNextWindow().maxTimestamp();
            return value.toBuilder().setTimestamp(nextWindowMax).build();
        }

        static Message of(String key, String value, Instant timestamp) {
            return new AutoValue_FillGapsTest_Message.Builder().setKey(key).setValue(value).setTimestamp(timestamp).build();
        }

        static TimestampedValue<Message> ofTimestamped(String key, String value, Instant timestamp) {
            return TimestampedValue.of((Object)Message.of(key, value, timestamp), (Instant)timestamp);
        }

        abstract Builder toBuilder();

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setKey(String var1);

            abstract Builder setValue(String var1);

            abstract Builder setTimestamp(Instant var1);

            abstract Message build();
        }
    }
}

