/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.timeseries;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Supplier;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.SortedMapCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.extensions.timeseries.AutoValue_FillGaps;
import org.apache.beam.sdk.extensions.timeseries.AutoValue_FillGaps_InterpolateData;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.transforms.WithKeys;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

@AutoValue
public abstract class FillGaps<@UnknownKeyFor ValueT>
extends PTransform<PCollection<ValueT>, PCollection<ValueT>> {
    private static final @UnknownKeyFor @NonNull @Initialized int GC_EVERY_N_BUCKETS = 60;

    public static <ValueT> @UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>> keepLatest() {
        return (SerializableBiFunction & Serializable)(v1, v2) -> v1.getTimestamp().isAfter((ReadableInstant)v2.getTimestamp()) ? v1 : v2;
    }

    public static <ValueT> @UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>> keepEarliest() {
        return (SerializableBiFunction & Serializable)(v1, v2) -> v1.getTimestamp().isAfter((ReadableInstant)v2.getTimestamp()) ? v2 : v1;
    }

    abstract @UnknownKeyFor @NonNull @Initialized Duration getTimeseriesBucketDuration();

    abstract @UnknownKeyFor @NonNull @Initialized Long getMaxGapFillBuckets();

    abstract @UnknownKeyFor @NonNull @Initialized Instant getStopTime();

    abstract @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor getKeyDescriptor();

    abstract @UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>> getMergeValues();

    abstract @UnknownKeyFor @NonNull @Initialized int getGcEveryNBuckets();

    @javax.annotation.Nullable
    abstract @UnknownKeyFor @Nullable @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized InterpolateData<ValueT>, ValueT> getInterpolateFunction();

    abstract @UnknownKeyFor @NonNull @Initialized Builder<ValueT> toBuilder();

    public static <ValueT> @UnknownKeyFor @NonNull @Initialized FillGaps<ValueT> of(@UnknownKeyFor @NonNull @Initialized Duration windowDuration, String ... keys) {
        return FillGaps.of(windowDuration, FieldAccessDescriptor.withFieldNames((String[])keys));
    }

    public static <ValueT> @UnknownKeyFor @NonNull @Initialized FillGaps<ValueT> of(@UnknownKeyFor @NonNull @Initialized Duration windowDuration, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor keyDescriptor) {
        return new AutoValue_FillGaps.Builder().setTimeseriesBucketDuration(windowDuration).setMaxGapFillBuckets(Long.MAX_VALUE).setStopTime(BoundedWindow.TIMESTAMP_MAX_VALUE).setKeyDescriptor(keyDescriptor).setMergeValues(FillGaps.keepLatest()).setGcEveryNBuckets(60).build();
    }

    public @UnknownKeyFor @NonNull @Initialized FillGaps<ValueT> withMaxGapFillBuckets(@UnknownKeyFor @NonNull @Initialized Long value) {
        return this.toBuilder().setMaxGapFillBuckets(value).build();
    }

    public @UnknownKeyFor @NonNull @Initialized FillGaps<ValueT> withStopTime(@UnknownKeyFor @NonNull @Initialized Instant stopTime) {
        return this.toBuilder().setStopTime(stopTime).build();
    }

    public @UnknownKeyFor @NonNull @Initialized FillGaps<ValueT> withMergeFunction(@UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>> mergeFunction) {
        return this.toBuilder().setMergeValues(mergeFunction).build();
    }

    public @UnknownKeyFor @NonNull @Initialized FillGaps<ValueT> withInterpolateFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized InterpolateData<ValueT>, ValueT> interpolateFunction) {
        return this.toBuilder().setInterpolateFunction(interpolateFunction).build();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<ValueT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<ValueT> input) {
        if (!input.hasSchema()) {
            throw new RuntimeException("The input to FillGaps must have a schema.");
        }
        FixedWindows bucketWindows = FixedWindows.of((Duration)this.getTimeseriesBucketDuration());
        PCollection keyedValues = (PCollection)((PCollection)input.apply("FixedWindow", (PTransform)Window.into((WindowFn)bucketWindows))).apply("withKeys", (PTransform)WithKeys.of((FieldAccessDescriptor)this.getKeyDescriptor()));
        WindowFn originalWindowFn = input.getWindowingStrategy().getWindowFn();
        return ((PCollection)((PCollection)((PCollection)keyedValues.apply("globalWindow", (PTransform)Window.into((WindowFn)new GlobalWindows()))).apply("fillGaps", (PTransform)ParDo.of(new FillGapsDoFn<ValueT>(bucketWindows, input.getCoder(), this.getStopTime(), this.getMaxGapFillBuckets(), this.getMergeValues(), this.getInterpolateFunction(), this.getGcEveryNBuckets())))).apply("applyOriginalWindow", (PTransform)Window.into((WindowFn)originalWindowFn))).setCoder(input.getCoder());
    }

    public static class FillGapsDoFn<@UnknownKeyFor ValueT>
    extends DoFn<KV<Row, ValueT>, ValueT> {
        private final @UnknownKeyFor @NonNull @Initialized FixedWindows bucketWindows;
        private final @UnknownKeyFor @NonNull @Initialized FixedWindows gcWindows;
        private final @UnknownKeyFor @NonNull @Initialized Instant stopTime;
        private final @UnknownKeyFor @NonNull @Initialized long maxGapFillBuckets;
        private final @UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>> mergeValues;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized InterpolateData<ValueT>, ValueT> interpolateFunction;
        @DoFn.TimerFamily(value="gapTimers")
        private final @UnknownKeyFor @NonNull @Initialized TimerSpec gapFillingTimersSpec = TimerSpecs.timerMap((TimeDomain)TimeDomain.EVENT_TIME);
        @DoFn.TimerFamily(value="gcTimers")
        private final @UnknownKeyFor @NonNull @Initialized TimerSpec gcTimersSpec = TimerSpecs.timerMap((TimeDomain)TimeDomain.EVENT_TIME);
        @DoFn.StateId(value="seenBuckets")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>>>> seenBucketsSpec;
        @DoFn.StateId(value="gapDurationMap")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Long>>> gapDurationSpec;

        FillGapsDoFn(@UnknownKeyFor @NonNull @Initialized FixedWindows bucketWindows, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> valueCoder, @UnknownKeyFor @NonNull @Initialized Instant stopTime, @UnknownKeyFor @NonNull @Initialized long maxGapFillBuckets, @UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>> mergeValues, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized InterpolateData<ValueT>, ValueT> interpolateFunction, @UnknownKeyFor @NonNull @Initialized int gcEveryNBuckets) {
            this.bucketWindows = bucketWindows;
            this.gcWindows = FixedWindows.of((Duration)bucketWindows.getSize().multipliedBy((long)gcEveryNBuckets));
            this.stopTime = stopTime;
            this.maxGapFillBuckets = maxGapFillBuckets;
            this.seenBucketsSpec = StateSpecs.value((Coder)SortedMapCoder.of((Coder)InstantCoder.of(), (Coder)TimestampedValue.TimestampedValueCoder.of(valueCoder)));
            this.gapDurationSpec = StateSpecs.value((Coder)SortedMapCoder.of((Coder)InstantCoder.of(), (Coder)VarLongCoder.of()));
            this.mergeValues = mergeValues;
            this.interpolateFunction = interpolateFunction;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, ValueT> element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant ts, @DoFn.TimerFamily(value="gapTimers") @UnknownKeyFor @NonNull @Initialized TimerMap gapTimers, @DoFn.TimerFamily(value="gcTimers") @UnknownKeyFor @NonNull @Initialized TimerMap gcTimers, @DoFn.AlwaysFetched @DoFn.StateId(value="seenBuckets") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>>> seenBuckets, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<ValueT> output) {
            if (ts.isAfter((ReadableInstant)this.stopTime)) {
                return;
            }
            Instant windowEndTs = this.bucketWindows.assignWindow(ts).end();
            if (this.processEvent(() -> TimestampedValue.of((Object)element.getValue(), (Instant)ts), windowEndTs, gapTimers, gcTimers, seenBuckets, -1L, output)) {
                gapTimers.get(this.windowToTimerTag(windowEndTs)).clear();
            }
        }

        private @UnknownKeyFor @NonNull @Initialized String windowToTimerTag(@UnknownKeyFor @NonNull @Initialized Instant endTs) {
            return Long.toString(endTs.getMillis());
        }

        private @UnknownKeyFor @NonNull @Initialized Instant windowFromTimerTag(@UnknownKeyFor @NonNull @Initialized String key) {
            return Instant.ofEpochMilli((long)Long.parseLong(key));
        }

        @DoFn.OnTimerFamily(value="gapTimers")
        public void onTimer(@DoFn.TimerId @UnknownKeyFor @NonNull @Initialized String timerId, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, @DoFn.TimerFamily(value="gapTimers") @UnknownKeyFor @NonNull @Initialized TimerMap gapTimers, @DoFn.TimerFamily(value="gcTimers") @UnknownKeyFor @NonNull @Initialized TimerMap gcTimers, @DoFn.AlwaysFetched @DoFn.StateId(value="seenBuckets") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>>> seenBuckets, @DoFn.AlwaysFetched @DoFn.StateId(value="gapDurationMap") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Long>> gapDurations, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<ValueT> output) {
            Instant bucketEndTs = this.windowFromTimerTag(timerId);
            Instant bucketMaxTs = bucketEndTs.minus((ReadableDuration)Duration.millis((long)1L));
            Instant previousBucketEndTs = bucketEndTs.minus((ReadableDuration)this.bucketWindows.getSize());
            Instant previousBucketMaxTs = previousBucketEndTs.minus((ReadableDuration)Duration.millis((long)1L));
            Map seenBucketMap = (Map)seenBuckets.read();
            if (seenBucketMap == null) {
                throw new RuntimeException("Unexpected timer fired with no seenBucketMap.");
            }
            SortedMap gapDurationsMap = (SortedMap)gapDurations.read();
            long gapSize = 0L;
            if (gapDurationsMap != null) {
                gapSize = gapDurationsMap.getOrDefault(previousBucketEndTs, 0L);
            }
            this.processEvent(() -> {
                TimestampedValue previous = (TimestampedValue)seenBucketMap.get(previousBucketEndTs);
                if (previous == null) {
                    throw new RuntimeException("Processing bucket for " + bucketEndTs + " before processing bucket for " + previousBucketEndTs);
                }
                Object value = previous.getValue();
                if (this.interpolateFunction != null) {
                    IntervalWindow previousBucket = this.bucketWindows.assignWindow(previousBucketMaxTs);
                    IntervalWindow currentBucket = this.bucketWindows.assignWindow(bucketMaxTs);
                    Preconditions.checkState((!currentBucket.equals(previousBucket) ? 1 : 0) != 0);
                    value = this.interpolateFunction.apply(new AutoValue_FillGaps_InterpolateData(previous, (BoundedWindow)previousBucket, (BoundedWindow)currentBucket));
                }
                return TimestampedValue.of((Object)value, (Instant)bucketMaxTs);
            }, bucketEndTs, gapTimers, gcTimers, seenBuckets, gapSize, output);
            if (!seenBucketMap.containsKey(bucketEndTs.plus((ReadableDuration)this.bucketWindows.getSize()))) {
                if (gapDurationsMap == null) {
                    gapDurationsMap = Maps.newTreeMap();
                }
                gapDurationsMap.put(bucketEndTs, gapSize + 1L);
                gapDurations.write((Object)gapDurationsMap);
            }
        }

        @DoFn.OnTimerFamily(value="gcTimers")
        public void onGcTimer(@DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timerTs, @DoFn.AlwaysFetched @DoFn.StateId(value="seenBuckets") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>>> seenBuckets, @DoFn.AlwaysFetched @DoFn.StateId(value="gapDurationMap") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Long>> gapDurations) {
            FillGapsDoFn.gcMap(seenBuckets, timerTs.minus((ReadableDuration)this.gcWindows.getSize()));
            FillGapsDoFn.gcMap(gapDurations, timerTs.minus((ReadableDuration)this.gcWindows.getSize()));
        }

        private @UnknownKeyFor @NonNull @Initialized boolean processEvent(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>> getValue, @UnknownKeyFor @NonNull @Initialized Instant bucketEndTs, @UnknownKeyFor @NonNull @Initialized TimerMap gapTimers, @UnknownKeyFor @NonNull @Initialized TimerMap gcTimers, @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>>> seenBuckets, @UnknownKeyFor @NonNull @Initialized long gapSize, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<ValueT> output) {
            TimestampedValue value = getValue.get();
            output.outputWithTimestamp(value.getValue(), value.getTimestamp());
            boolean firstElementInBucket = true;
            TimestampedValue valueToWrite = value;
            SortedMap seenBucketsMap = (SortedMap)seenBuckets.read();
            if (seenBucketsMap == null) {
                seenBucketsMap = Maps.newTreeMap();
            } else {
                TimestampedValue existing = (TimestampedValue)seenBucketsMap.get(bucketEndTs);
                if (existing != null) {
                    valueToWrite = (TimestampedValue)this.mergeValues.apply((Object)existing, value);
                    firstElementInBucket = false;
                }
            }
            seenBucketsMap.put(bucketEndTs, valueToWrite);
            seenBuckets.write((Object)seenBucketsMap);
            if (firstElementInBucket) {
                Instant nextBucketEndTs = bucketEndTs.plus((ReadableDuration)this.bucketWindows.getSize());
                Instant nextBucketMaxTs = nextBucketEndTs.minus((ReadableDuration)Duration.millis((long)1L));
                if (nextBucketMaxTs.isBefore((ReadableInstant)this.stopTime) && gapSize + 1L < this.maxGapFillBuckets && !seenBucketsMap.containsKey(nextBucketEndTs)) {
                    gapTimers.get(this.windowToTimerTag(nextBucketEndTs)).withOutputTimestamp(bucketEndTs).set(nextBucketEndTs);
                }
                Instant gcTs = this.gcWindows.assignWindow(nextBucketEndTs).end();
                gcTimers.get(this.windowToTimerTag(gcTs)).set(gcTs);
            }
            return firstElementInBucket;
        }

        private static <V> void gcMap(@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized Instant, V>> mapState, @UnknownKeyFor @NonNull @Initialized Instant ts) {
            SortedMap map = (SortedMap)mapState.read();
            if (map != null) {
                map.headMap(ts).clear();
                if (map.isEmpty()) {
                    mapState.clear();
                } else {
                    mapState.write((Object)map);
                }
            }
        }
    }

    @AutoValue.Builder
    static abstract class Builder<@UnknownKeyFor ValueT> {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder<ValueT> setTimeseriesBucketDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<ValueT> setMaxGapFillBuckets(@UnknownKeyFor @NonNull @Initialized Long var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<ValueT> setStopTime(@UnknownKeyFor @NonNull @Initialized Instant var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<ValueT> setKeyDescriptor(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<ValueT> setMergeValues(@UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>, @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT>> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<ValueT> setInterpolateFunction(@javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized InterpolateData<ValueT>, ValueT> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<ValueT> setGcEveryNBuckets(@UnknownKeyFor @NonNull @Initialized int var1);

        abstract @UnknownKeyFor @NonNull @Initialized FillGaps<ValueT> build();
    }

    @AutoValue
    public static abstract class InterpolateData<@UnknownKeyFor ValueT> {
        public abstract @UnknownKeyFor @NonNull @Initialized TimestampedValue<ValueT> getValue();

        public abstract @UnknownKeyFor @NonNull @Initialized BoundedWindow getPreviousWindow();

        public abstract @UnknownKeyFor @NonNull @Initialized BoundedWindow getNextWindow();
    }
}

