/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.timeseries;

import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.timeseries.FillGaps;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Duration;
import org.joda.time.Instant;

final class AutoValue_FillGaps<ValueT>
extends FillGaps<ValueT> {
    private final Duration timeseriesBucketDuration;
    private final Long maxGapFillBuckets;
    private final Instant stopTime;
    private final FieldAccessDescriptor keyDescriptor;
    private final SerializableBiFunction<TimestampedValue<ValueT>, TimestampedValue<ValueT>, TimestampedValue<ValueT>> mergeValues;
    private final int gcEveryNBuckets;
    private final SerializableFunction<FillGaps.InterpolateData<ValueT>, ValueT> interpolateFunction;

    private AutoValue_FillGaps(Duration timeseriesBucketDuration, Long maxGapFillBuckets, Instant stopTime, FieldAccessDescriptor keyDescriptor, SerializableBiFunction<TimestampedValue<ValueT>, TimestampedValue<ValueT>, TimestampedValue<ValueT>> mergeValues, int gcEveryNBuckets, @Nullable SerializableFunction<FillGaps.InterpolateData<ValueT>, ValueT> interpolateFunction) {
        this.timeseriesBucketDuration = timeseriesBucketDuration;
        this.maxGapFillBuckets = maxGapFillBuckets;
        this.stopTime = stopTime;
        this.keyDescriptor = keyDescriptor;
        this.mergeValues = mergeValues;
        this.gcEveryNBuckets = gcEveryNBuckets;
        this.interpolateFunction = interpolateFunction;
    }

    @Override
    Duration getTimeseriesBucketDuration() {
        return this.timeseriesBucketDuration;
    }

    @Override
    Long getMaxGapFillBuckets() {
        return this.maxGapFillBuckets;
    }

    @Override
    Instant getStopTime() {
        return this.stopTime;
    }

    @Override
    FieldAccessDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    @Override
    SerializableBiFunction<TimestampedValue<ValueT>, TimestampedValue<ValueT>, TimestampedValue<ValueT>> getMergeValues() {
        return this.mergeValues;
    }

    @Override
    int getGcEveryNBuckets() {
        return this.gcEveryNBuckets;
    }

    @Override
    @Nullable
    SerializableFunction<FillGaps.InterpolateData<ValueT>, ValueT> getInterpolateFunction() {
        return this.interpolateFunction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FillGaps) {
            FillGaps that = (FillGaps)((Object)o);
            return this.timeseriesBucketDuration.equals((Object)that.getTimeseriesBucketDuration()) && this.maxGapFillBuckets.equals(that.getMaxGapFillBuckets()) && this.stopTime.equals((Object)that.getStopTime()) && this.keyDescriptor.equals(that.getKeyDescriptor()) && this.mergeValues.equals(that.getMergeValues()) && this.gcEveryNBuckets == that.getGcEveryNBuckets() && (this.interpolateFunction == null ? that.getInterpolateFunction() == null : this.interpolateFunction.equals(that.getInterpolateFunction()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.timeseriesBucketDuration.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxGapFillBuckets.hashCode();
        h$ *= 1000003;
        h$ ^= this.stopTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyDescriptor.hashCode();
        h$ *= 1000003;
        h$ ^= this.mergeValues.hashCode();
        h$ *= 1000003;
        h$ ^= this.gcEveryNBuckets;
        h$ *= 1000003;
        return h$ ^= this.interpolateFunction == null ? 0 : this.interpolateFunction.hashCode();
    }

    @Override
    FillGaps.Builder<ValueT> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<ValueT>
    extends FillGaps.Builder<ValueT> {
        private Duration timeseriesBucketDuration;
        private Long maxGapFillBuckets;
        private Instant stopTime;
        private FieldAccessDescriptor keyDescriptor;
        private SerializableBiFunction<TimestampedValue<ValueT>, TimestampedValue<ValueT>, TimestampedValue<ValueT>> mergeValues;
        private Integer gcEveryNBuckets;
        private SerializableFunction<FillGaps.InterpolateData<ValueT>, ValueT> interpolateFunction;

        Builder() {
        }

        private Builder(FillGaps<ValueT> source) {
            this.timeseriesBucketDuration = source.getTimeseriesBucketDuration();
            this.maxGapFillBuckets = source.getMaxGapFillBuckets();
            this.stopTime = source.getStopTime();
            this.keyDescriptor = source.getKeyDescriptor();
            this.mergeValues = source.getMergeValues();
            this.gcEveryNBuckets = source.getGcEveryNBuckets();
            this.interpolateFunction = source.getInterpolateFunction();
        }

        @Override
        FillGaps.Builder<ValueT> setTimeseriesBucketDuration(Duration timeseriesBucketDuration) {
            if (timeseriesBucketDuration == null) {
                throw new NullPointerException("Null timeseriesBucketDuration");
            }
            this.timeseriesBucketDuration = timeseriesBucketDuration;
            return this;
        }

        @Override
        FillGaps.Builder<ValueT> setMaxGapFillBuckets(Long maxGapFillBuckets) {
            if (maxGapFillBuckets == null) {
                throw new NullPointerException("Null maxGapFillBuckets");
            }
            this.maxGapFillBuckets = maxGapFillBuckets;
            return this;
        }

        @Override
        FillGaps.Builder<ValueT> setStopTime(Instant stopTime) {
            if (stopTime == null) {
                throw new NullPointerException("Null stopTime");
            }
            this.stopTime = stopTime;
            return this;
        }

        @Override
        FillGaps.Builder<ValueT> setKeyDescriptor(FieldAccessDescriptor keyDescriptor) {
            if (keyDescriptor == null) {
                throw new NullPointerException("Null keyDescriptor");
            }
            this.keyDescriptor = keyDescriptor;
            return this;
        }

        @Override
        FillGaps.Builder<ValueT> setMergeValues(SerializableBiFunction<TimestampedValue<ValueT>, TimestampedValue<ValueT>, TimestampedValue<ValueT>> mergeValues) {
            if (mergeValues == null) {
                throw new NullPointerException("Null mergeValues");
            }
            this.mergeValues = mergeValues;
            return this;
        }

        @Override
        FillGaps.Builder<ValueT> setGcEveryNBuckets(int gcEveryNBuckets) {
            this.gcEveryNBuckets = gcEveryNBuckets;
            return this;
        }

        @Override
        FillGaps.Builder<ValueT> setInterpolateFunction(@Nullable SerializableFunction<FillGaps.InterpolateData<ValueT>, ValueT> interpolateFunction) {
            this.interpolateFunction = interpolateFunction;
            return this;
        }

        @Override
        FillGaps<ValueT> build() {
            if (this.timeseriesBucketDuration == null || this.maxGapFillBuckets == null || this.stopTime == null || this.keyDescriptor == null || this.mergeValues == null || this.gcEveryNBuckets == null) {
                StringBuilder missing = new StringBuilder();
                if (this.timeseriesBucketDuration == null) {
                    missing.append(" timeseriesBucketDuration");
                }
                if (this.maxGapFillBuckets == null) {
                    missing.append(" maxGapFillBuckets");
                }
                if (this.stopTime == null) {
                    missing.append(" stopTime");
                }
                if (this.keyDescriptor == null) {
                    missing.append(" keyDescriptor");
                }
                if (this.mergeValues == null) {
                    missing.append(" mergeValues");
                }
                if (this.gcEveryNBuckets == null) {
                    missing.append(" gcEveryNBuckets");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FillGaps(this.timeseriesBucketDuration, this.maxGapFillBuckets, this.stopTime, this.keyDescriptor, this.mergeValues, this.gcEveryNBuckets, this.interpolateFunction);
        }
    }
}

