/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.utils;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.schemas.Schema;

public class QuickCheckGenerators {
    private static final FieldTypeGenerator PRIMITIVE_TYPES = new PrimitiveTypes();
    private static final FieldTypeGenerator ARRAYS_OF_ANY = new Arrays();
    private static final FieldTypeGenerator MAPS_OF_ANY = new Maps();
    private static final FieldTypeGenerator ROWS = new Rows();
    private static final FieldTypeGenerator ANY_TYPE = new AnyFieldType();

    static abstract class FieldTypeGenerator
    extends Generator<Schema.FieldType> {
        static final GenerationStatus.Key<Integer> NESTING_KEY = new GenerationStatus.Key("nesting", Integer.class);

        FieldTypeGenerator() {
            super(Schema.FieldType.class);
        }

        public Schema.FieldType generate(SourceOfRandomness random, GenerationStatus status) {
            this.incrementNesting(status);
            return this.generateFieldType(random, status);
        }

        protected abstract Schema.FieldType generateFieldType(SourceOfRandomness var1, GenerationStatus var2);

        int nestingLevel(GenerationStatus status) {
            return status.valueOf(NESTING_KEY).orElse(-1);
        }

        void incrementNesting(GenerationStatus status) {
            status.setValue(NESTING_KEY, (Object)(this.nestingLevel(status) + 1));
        }
    }

    public static class AnyFieldType
    extends FieldTypeGenerator {
        @Override
        public Schema.FieldType generateFieldType(SourceOfRandomness random, GenerationStatus status) {
            return ((FieldTypeGenerator)((Object)random.choose(java.util.Arrays.asList(PRIMITIVE_TYPES, ARRAYS_OF_ANY, MAPS_OF_ANY, ROWS)))).generate(random, status);
        }
    }

    public static class Rows
    extends FieldTypeGenerator {
        @Override
        public Schema.FieldType generateFieldType(SourceOfRandomness random, GenerationStatus status) {
            FieldTypeGenerator rowFieldTypesGenerator = this.nestingLevel(status) >= 10 ? PRIMITIVE_TYPES : ANY_TYPE;
            return Schema.FieldType.row((Schema)this.generateSchema(rowFieldTypesGenerator, random, status));
        }

        private Schema generateSchema(FieldTypeGenerator fieldTypeGenerator, SourceOfRandomness random, GenerationStatus status) {
            return (Schema)IntStream.range(0, status.size() + 1).mapToObj(i -> Schema.Field.of((String)("field_" + i), (Schema.FieldType)fieldTypeGenerator.generate(random, status)).withNullable(true)).collect(Schema.toSchema());
        }
    }

    public static class Maps
    extends FieldTypeGenerator {
        @Override
        public Schema.FieldType generateFieldType(SourceOfRandomness random, GenerationStatus status) {
            return Schema.FieldType.map((Schema.FieldType)PRIMITIVE_TYPES.generate(random, status), (Schema.FieldType)ANY_TYPE.generate(random, status));
        }
    }

    public static class Arrays
    extends FieldTypeGenerator {
        @Override
        public Schema.FieldType generateFieldType(SourceOfRandomness random, GenerationStatus status) {
            return Schema.FieldType.array((Schema.FieldType)ANY_TYPE.generate(random, status));
        }
    }

    public static class PrimitiveTypes
    extends FieldTypeGenerator {
        private static final List<Schema.FieldType> PRIMITIVE_TYPES = java.util.Arrays.stream(Schema.TypeName.values()).filter(Schema.TypeName::isPrimitiveType).map(Schema.FieldType::of).collect(Collectors.toList());

        @Override
        public Schema.FieldType generateFieldType(SourceOfRandomness random, GenerationStatus status) {
            return (Schema.FieldType)random.choose(PRIMITIVE_TYPES);
        }
    }
}

