/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.mock.MockedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;

public class MockedBoundedTable
extends MockedTable {
    private static final ConcurrentLinkedQueue<Row> CONTENT = new ConcurrentLinkedQueue();
    private final List<Row> rows = new ArrayList<Row>();

    public MockedBoundedTable(Schema beamSchema) {
        super(beamSchema);
    }

    public static MockedBoundedTable of(Object ... args) {
        return new MockedBoundedTable(TestUtils.buildBeamSqlSchema(args));
    }

    public static MockedBoundedTable of(Schema type) {
        return new MockedBoundedTable(type);
    }

    public MockedBoundedTable addRows(Object ... args) {
        List<Row> rows = TestUtils.buildRows(this.getSchema(), Arrays.asList(args));
        this.rows.addAll(rows);
        return this;
    }

    public PCollection<Row> buildIOReader(PBegin begin) {
        return ((PCollection)begin.apply("MockedBoundedTable_Reader_" + COUNTER.incrementAndGet(), (PTransform)Create.of(this.rows))).setRowSchema(this.getSchema());
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        input.apply((PTransform)ParDo.of((DoFn)new DoFn<Row, Void>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                CONTENT.add((Row)c.element());
            }

            @DoFn.Teardown
            public void close() {
                CONTENT.clear();
            }
        }));
        return PDone.in((Pipeline)input.getPipeline());
    }
}

