/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.pubsub;

import com.alibaba.fastjson.JSON;
import junit.framework.TestCase;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.PubsubJsonTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PubsubJsonTableProviderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testTableTypePubsub() {
        PubsubJsonTableProvider provider = new PubsubJsonTableProvider();
        Assert.assertEquals((Object)"pubsub", (Object)provider.getTableType());
    }

    @Test
    public void testCreatesTable() {
        PubsubJsonTableProvider provider = new PubsubJsonTableProvider();
        Schema messageSchema = Schema.builder().addDateTimeField("event_timestamp").addMapField("attributes", CalciteUtils.VARCHAR, CalciteUtils.VARCHAR).addRowField("payload", Schema.builder().build()).build();
        Table tableDefinition = PubsubJsonTableProviderTest.tableDefinition().schema(messageSchema).build();
        BeamSqlTable pubsubTable = provider.buildBeamSqlTable(tableDefinition);
        TestCase.assertNotNull((Object)pubsubTable);
        Assert.assertEquals((Object)messageSchema, (Object)pubsubTable.getSchema());
    }

    @Test
    public void testThrowsIfTimestampFieldNotProvided() {
        PubsubJsonTableProvider provider = new PubsubJsonTableProvider();
        Schema messageSchema = Schema.builder().addMapField("attributes", CalciteUtils.VARCHAR, CalciteUtils.VARCHAR).addRowField("payload", Schema.builder().build()).build();
        Table tableDefinition = PubsubJsonTableProviderTest.tableDefinition().schema(messageSchema).build();
        this.thrown.expectMessage("Unsupported");
        this.thrown.expectMessage("'event_timestamp'");
        provider.buildBeamSqlTable(tableDefinition);
    }

    @Test
    public void testThrowsIfAttributesFieldNotProvided() {
        PubsubJsonTableProvider provider = new PubsubJsonTableProvider();
        Schema messageSchema = Schema.builder().addDateTimeField("event_timestamp").addRowField("payload", Schema.builder().build()).build();
        Table tableDefinition = PubsubJsonTableProviderTest.tableDefinition().schema(messageSchema).build();
        this.thrown.expectMessage("Unsupported");
        this.thrown.expectMessage("'attributes'");
        provider.buildBeamSqlTable(tableDefinition);
    }

    @Test
    public void testThrowsIfPayloadFieldNotProvided() {
        PubsubJsonTableProvider provider = new PubsubJsonTableProvider();
        Schema messageSchema = Schema.builder().addDateTimeField("event_timestamp").addMapField("attributes", CalciteUtils.VARCHAR, CalciteUtils.VARCHAR).build();
        Table tableDefinition = PubsubJsonTableProviderTest.tableDefinition().schema(messageSchema).build();
        this.thrown.expectMessage("Unsupported");
        this.thrown.expectMessage("'payload'");
        provider.buildBeamSqlTable(tableDefinition);
    }

    @Test
    public void testThrowsIfExtraFieldsExist() {
        PubsubJsonTableProvider provider = new PubsubJsonTableProvider();
        Schema messageSchema = Schema.builder().addDateTimeField("event_timestamp").addMapField("attributes", CalciteUtils.VARCHAR, CalciteUtils.VARCHAR).addStringField("someField").addRowField("payload", Schema.builder().build()).build();
        Table tableDefinition = PubsubJsonTableProviderTest.tableDefinition().schema(messageSchema).build();
        this.thrown.expectMessage("Unsupported");
        this.thrown.expectMessage("'event_timestamp'");
        provider.buildBeamSqlTable(tableDefinition);
    }

    private static Table.Builder tableDefinition() {
        return Table.builder().name("FakeTable").comment("fake table").location("projects/project/topics/topic").schema(Schema.builder().build()).type("pubsub").properties(JSON.parseObject((String)"{ \"timestampAttributeKey\" : \"ts_field\" }"));
    }
}

