/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.stream.Stream;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaCSVTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.KafkaTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Assert;
import org.junit.Test;

public class KafkaTableProviderTest {
    private KafkaTableProvider provider = new KafkaTableProvider();

    @Test
    public void testBuildBeamSqlTable() throws Exception {
        Table table = KafkaTableProviderTest.mockTable("hello");
        BeamSqlTable sqlTable = this.provider.buildBeamSqlTable(table);
        Assert.assertNotNull((Object)sqlTable);
        Assert.assertTrue((boolean)(sqlTable instanceof BeamKafkaCSVTable));
        BeamKafkaCSVTable csvTable = (BeamKafkaCSVTable)sqlTable;
        Assert.assertEquals((Object)"localhost:9092", (Object)csvTable.getBootstrapServers());
        Assert.assertEquals(ImmutableList.of("topic1", "topic2"), (Object)csvTable.getTopics());
    }

    @Test
    public void testGetTableType() throws Exception {
        Assert.assertEquals((Object)"kafka", (Object)this.provider.getTableType());
    }

    private static Table mockTable(String name) {
        JSONObject properties = new JSONObject();
        properties.put("bootstrap.servers", (Object)"localhost:9092");
        JSONArray topics = new JSONArray();
        topics.add((Object)"topic1");
        topics.add((Object)"topic2");
        properties.put("topics", (Object)topics);
        return Table.builder().name(name).comment(name + " table").location("kafka://localhost:2181/brokers?topic=test").schema((Schema)Stream.of(Schema.Field.nullable((String)"id", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.nullable((String)"name", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema())).type("kafka").properties(properties).build();
    }
}

