/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaCSVTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.commons.csv.CSVFormat;
import org.junit.Rule;
import org.junit.Test;

public class BeamKafkaCSVTableTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    private static final Row ROW1 = Row.withSchema((Schema)BeamKafkaCSVTableTest.genSchema()).addValues(new Object[]{1L, 1, 1.0}).build();
    private static final Row ROW2 = Row.withSchema((Schema)BeamKafkaCSVTableTest.genSchema()).addValues(new Object[]{2L, 2, 2.0}).build();

    @Test
    public void testCsvRecorderDecoder() throws Exception {
        PCollection result = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"1,\"1\",1.0", (Object[])new String[]{"2,2,2.0"}))).apply((PTransform)ParDo.of((DoFn)new String2KvBytes()))).apply((PTransform)new BeamKafkaCSVTable.CsvRecorderDecoder(BeamKafkaCSVTableTest.genSchema(), CSVFormat.DEFAULT));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{ROW1, ROW2});
        this.pipeline.run();
    }

    @Test
    public void testCsvRecorderEncoder() throws Exception {
        PCollection result = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)ROW1, (Object[])new Row[]{ROW2}))).apply((PTransform)new BeamKafkaCSVTable.CsvRecorderEncoder(BeamKafkaCSVTableTest.genSchema(), CSVFormat.DEFAULT))).apply((PTransform)new BeamKafkaCSVTable.CsvRecorderDecoder(BeamKafkaCSVTableTest.genSchema(), CSVFormat.DEFAULT));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{ROW1, ROW2});
        this.pipeline.run();
    }

    private static Schema genSchema() {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        return CalciteUtils.toSchema((RelDataType)typeFactory.builder().add("order_id", SqlTypeName.BIGINT).add("site_id", SqlTypeName.INTEGER).add("price", SqlTypeName.DOUBLE).build());
    }

    private static class String2KvBytes
    extends DoFn<String, KV<byte[], byte[]>>
    implements Serializable {
        private String2KvBytes() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext ctx) {
            ctx.output((Object)KV.of((Object)new byte[0], (Object)((String)ctx.element()).getBytes(StandardCharsets.UTF_8)));
        }
    }
}

