/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.integrationtest;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.JdbcDriver;
import org.apache.beam.sdk.extensions.sql.integrationtest.AutoValue_BeamSqlBuiltinFunctionsIntegrationTestBase_ExpressionTestCase;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.extensions.sql.mock.MockedBoundedTable;
import org.apache.beam.sdk.extensions.sql.utils.RowAsserts;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.junit.Assert;
import org.junit.Rule;

public class BeamSqlBuiltinFunctionsIntegrationTestBase {
    private static final double PRECISION_DOUBLE = 1.0E-7;
    private static final float PRECISION_FLOAT = 1.0E-7f;
    private static final Map<Class, Schema.TypeName> JAVA_CLASS_TO_TYPENAME = ImmutableMap.builder().put(Byte.class, Schema.TypeName.BYTE).put(Short.class, Schema.TypeName.INT16).put(Integer.class, Schema.TypeName.INT32).put(Long.class, Schema.TypeName.INT64).put(Float.class, Schema.TypeName.FLOAT).put(Double.class, Schema.TypeName.DOUBLE).put(BigDecimal.class, Schema.TypeName.DECIMAL).put(String.class, Schema.TypeName.STRING).put(DateTime.class, Schema.TypeName.DATETIME).put(Boolean.class, Schema.TypeName.BOOLEAN).build();
    private static final Schema ROW_TYPE = Schema.builder().addDateTimeField("ts").addByteField("c_tinyint").addInt16Field("c_smallint").addInt32Field("c_integer").addInt64Field("c_bigint").addFloatField("c_float").addDoubleField("c_double").addDecimalField("c_decimal").addByteField("c_tinyint_max").addInt16Field("c_smallint_max").addInt32Field("c_integer_max").addInt64Field("c_bigint_max").build();
    private static final Schema ROW_TYPE_TWO = Schema.builder().addNullableField("ts", Schema.FieldType.DATETIME).addNullableField("c_tinyint", Schema.FieldType.BYTE).addNullableField("c_smallint", Schema.FieldType.INT16).addNullableField("c_integer", Schema.FieldType.INT32).addNullableField("c_integer_two", Schema.FieldType.INT32).addNullableField("c_bigint", Schema.FieldType.INT64).addNullableField("c_float", Schema.FieldType.FLOAT).addNullableField("c_double", Schema.FieldType.DOUBLE).addNullableField("c_double_two", Schema.FieldType.DOUBLE).addNullableField("c_decimal", Schema.FieldType.DECIMAL).build();
    private static final Schema ROW_TYPE_THREE = Schema.builder().addField("ts", Schema.FieldType.DATETIME).addField("c_double", Schema.FieldType.DOUBLE).build();
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    protected PCollection<Row> getTestPCollection() {
        try {
            return MockedBoundedTable.of(ROW_TYPE).addRows(BeamSqlBuiltinFunctionsIntegrationTestBase.parseDate("1986-02-15 11:35:26"), (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigDecimal.ONE, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE).buildIOReader(this.pipeline.begin()).setRowSchema(ROW_TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected PCollection<Row> getFloorCeilingTestPCollection() {
        try {
            return MockedBoundedTable.of(ROW_TYPE_THREE).addRows(BeamSqlBuiltinFunctionsIntegrationTestBase.parseDate("1986-02-15 11:35:26"), 1.4).buildIOReader(this.pipeline.begin()).setRowSchema(ROW_TYPE_THREE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected PCollection<Row> getAggregationTestPCollection() {
        try {
            return MockedBoundedTable.of(ROW_TYPE_TWO).addRows(BeamSqlBuiltinFunctionsIntegrationTestBase.parseDate("1986-02-15 11:35:26"), (byte)1, (short)1, 1, 5, 1L, Float.valueOf(1.0f), 1.0, 7.0, BigDecimal.valueOf(1.0)).addRows(BeamSqlBuiltinFunctionsIntegrationTestBase.parseDate("1986-03-15 11:35:26"), (byte)2, (short)2, 2, 6, 2L, Float.valueOf(2.0f), 2.0, 8.0, BigDecimal.valueOf(2.0)).addRows(BeamSqlBuiltinFunctionsIntegrationTestBase.parseDate("1986-04-15 11:35:26"), (byte)3, (short)3, 3, 7, 3L, Float.valueOf(3.0f), 3.0, 9.0, BigDecimal.valueOf(3.0)).addRows(null, null, null, null, null, null, null, null, null, null).buildIOReader(this.pipeline.begin()).setRowSchema(ROW_TYPE_TWO);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static DateTime parseDate(String str) {
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC().parseDateTime(str);
    }

    public static class SqlExpressionChecker {
        private transient List<String> exprs = new ArrayList<String>();
        private static final Schema DUMMY_SCHEMA = Schema.builder().addBooleanField("dummy").build();
        private static final Row DUMMY_ROW = Row.withSchema((Schema)DUMMY_SCHEMA).addValue((Object)true).build();
        private static final ReadOnlyTableProvider BOUNDED_TABLE = new ReadOnlyTableProvider("test", ImmutableMap.of("test", MockedBoundedTable.of(Schema.FieldType.INT32, "id", Schema.FieldType.STRING, "name").addRows(1, "first")));

        public SqlExpressionChecker addExpr(String expr) {
            this.exprs.add(expr);
            return this;
        }

        public void check(Pipeline pipeline) throws Exception {
            this.checkPTransform(pipeline);
            this.checkJdbc();
        }

        private void checkPTransform(Pipeline pipeline) {
            for (String expr : this.exprs) {
                pipeline.apply(expr, (PTransform)new CheckPTransform(expr));
            }
        }

        private void checkJdbc() throws Exception {
            TestTableProvider tableProvider = new TestTableProvider();
            CalciteConnection connection = JdbcDriver.connect((TableProvider)tableProvider);
            connection.createStatement().executeUpdate("CREATE TABLE dummy (dummy BOOLEAN) TYPE 'test'");
            tableProvider.addRows("dummy", new Row[]{DUMMY_ROW});
            for (String expr : this.exprs) {
                ResultSet exprResult = connection.createStatement().executeQuery(String.format("SELECT %s FROM dummy", expr));
                exprResult.next();
                exprResult.getBoolean(1);
                Assert.assertTrue((String)("Test expression is false: " + expr), (boolean)exprResult.getBoolean(1));
            }
        }

        private static class CheckPTransform
        extends PTransform<PBegin, PDone> {
            private final String expr;

            private CheckPTransform(String expr) {
                this.expr = expr;
            }

            public PDone expand(PBegin begin) {
                PCollection result = (PCollection)((PCollection)((PCollection)begin.apply((PTransform)Create.of((Object)DUMMY_ROW, (Object[])new Row[0]).withSchema(DUMMY_SCHEMA, SerializableFunctions.identity(), SerializableFunctions.identity()))).apply((PTransform)SqlTransform.query((String)("SELECT " + this.expr)))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.booleans()).via((SerializableFunction & Serializable)row -> row.getBoolean(0)));
                PAssert.that((PCollection)result).satisfies((SerializableFunction & Serializable)input -> {
                    Assert.assertTrue((String)("Test expression is false: " + this.expr), (boolean)((Boolean)Iterables.getOnlyElement(input)));
                    return null;
                });
                return PDone.in((Pipeline)begin.getPipeline());
            }
        }
    }

    public class ExpressionChecker {
        private transient List<ExpressionTestCase> exps = new ArrayList<ExpressionTestCase>();

        public ExpressionChecker addExpr(String expression, Object expectedValue) {
            Schema.TypeName resultTypeName = (Schema.TypeName)JAVA_CLASS_TO_TYPENAME.get(expectedValue.getClass());
            Preconditions.checkArgument(resultTypeName != null, String.format("The type of the expected value '%s' is unknown in 'addExpr(String expression, Object expectedValue)'. Please use 'addExpr(String expr, Object expected, FieldType type)' instead and provide the type of the expected object", expectedValue));
            this.addExpr(expression, expectedValue, Schema.FieldType.of((Schema.TypeName)resultTypeName));
            return this;
        }

        public ExpressionChecker addExpr(String expression, Object expectedValue, Schema.FieldType resultFieldType) {
            this.exps.add(ExpressionTestCase.of(expression, expectedValue, resultFieldType));
            return this;
        }

        public void buildRunAndCheck() {
            this.buildRunAndCheck(BeamSqlBuiltinFunctionsIntegrationTestBase.this.getTestPCollection());
        }

        public void buildRunAndCheck(PCollection<Row> inputCollection) {
            for (ExpressionTestCase testCase : this.exps) {
                String expression = testCase.sqlExpr();
                Object expectedValue = testCase.expectedResult();
                String sql = String.format("SELECT %s FROM PCOLLECTION", expression);
                Schema schema = expectedValue == null ? Schema.builder().addNullableField(expression, testCase.resultFieldType()).build() : Schema.builder().addField(expression, testCase.resultFieldType()).build();
                PCollection output = (PCollection)inputCollection.apply(testCase.toString(), (PTransform)SqlTransform.query((String)sql));
                if (expectedValue instanceof Double) {
                    PAssert.that((PCollection)output).satisfies(RowAsserts.matchesScalar((Double)expectedValue, 1.0E-7));
                    continue;
                }
                if (expectedValue instanceof Float) {
                    PAssert.that((PCollection)output).satisfies(RowAsserts.matchesScalar(((Float)expectedValue).floatValue(), 1.0E-7f));
                    continue;
                }
                PAssert.that((PCollection)output).containsInAnyOrder(TestUtils.RowsBuilder.of(schema).addRows(expectedValue).getRows());
            }
            inputCollection.getPipeline().run();
        }
    }

    @AutoValue
    static abstract class ExpressionTestCase {
        ExpressionTestCase() {
        }

        private static ExpressionTestCase of(String sqlExpr, Object expectedResult, Schema.FieldType resultFieldType) {
            return new AutoValue_BeamSqlBuiltinFunctionsIntegrationTestBase_ExpressionTestCase(sqlExpr, expectedResult, resultFieldType);
        }

        abstract String sqlExpr();

        @Nullable
        abstract Object expectedResult();

        abstract Schema.FieldType resultFieldType();
    }
}

