/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Optional;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.utils.SqlTypeUtils;
import org.junit.Assert;
import org.junit.Test;

public class SqlTypeUtilsTest {
    private static final BigDecimal DECIMAL_THREE = new BigDecimal(3);
    private static final BigDecimal DECIMAL_FOUR = new BigDecimal(4);
    private static final List<BeamSqlExpression> EXPRESSIONS = Arrays.asList(BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTERVAL_DAY, (Object)DECIMAL_THREE), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTERVAL_MONTH, (Object)DECIMAL_FOUR), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)4), BeamSqlPrimitive.of((SqlTypeName)SqlTypeName.INTEGER, (Object)5));

    @Test
    public void testFindExpressionOfType_success() {
        Optional typeName = SqlTypeUtils.findExpressionOfType(EXPRESSIONS, (SqlTypeName)SqlTypeName.INTEGER);
        Assert.assertTrue((boolean)typeName.isPresent());
        Assert.assertEquals((Object)((Object)SqlTypeName.INTEGER), (Object)((Object)((BeamSqlExpression)typeName.get()).getOutputType()));
    }

    @Test
    public void testFindExpressionOfType_failure() {
        Optional typeName = SqlTypeUtils.findExpressionOfType(EXPRESSIONS, (SqlTypeName)SqlTypeName.VARCHAR);
        Assert.assertFalse((boolean)typeName.isPresent());
    }

    @Test
    public void testFindExpressionOfTypes_success() {
        Optional typeName = SqlTypeUtils.findExpressionOfType(EXPRESSIONS, SqlTypeName.INT_TYPES);
        Assert.assertTrue((boolean)typeName.isPresent());
        Assert.assertEquals((Object)((Object)SqlTypeName.INTEGER), (Object)((Object)((BeamSqlExpression)typeName.get()).getOutputType()));
    }

    @Test
    public void testFindExpressionOfTypes_failure() {
        Optional typeName = SqlTypeUtils.findExpressionOfType(EXPRESSIONS, SqlTypeName.CHAR_TYPES);
        Assert.assertFalse((boolean)typeName.isPresent());
    }
}

